<?php
/**
 * Single Event Template
 * A single event. This displays the event title, description, meta, and
 * optionally, the Google map for the event.
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/single-event.php
 *
 * @package TribeEventsCalendar
 * @version 4.2.4
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}
global $post;
$event_id = get_the_ID();

$data = \CONAT\Includes\Classes\Common::instance()->data( 'single' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
$layout = ( $layout ) ? $layout : 'right';
$sidebar = ( $sidebar ) ? $sidebar : 'blog-sidebar';
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-xs-12 col-sm-12 col-md-12' : 'col-lg-8 col-md-12 col-sm-12';
$options = conat_WSH()->option();

$event_thumbnail_id = get_post_thumbnail_id($event_id);
$event_thumbnail_url = wp_get_attachment_url($event_thumbnail_id);

$start_datetime = tribe_get_start_date( $event_id );
$end_datetime = tribe_get_end_date( $event_id );

$start_date = tribe_get_start_date($event_id, null, false, 'd' );
$end_date = tribe_get_end_date($event_id, null, false, 'd M, Y' );

$start_time = tribe_get_start_time ( $event_id, 'h:i A' );
$end_time = tribe_get_end_time ( $event_id, 'h:i A' );

$location = get_post_meta( $event_id, 'location', true );
$vanue = tribe_get_venue($event_id);
?>

<!-- Page Title -->
<section class="page-title" <?php if ($data->get( 'banner' )){ ?>style="background-image: url(<?php echo esc_url( $data->get( 'banner' ) ); ?>)"<?php } ?>>
    <div class="auto-container">
        <div class="d-flex justify-content-between align-items-center flex-wrap">
            <div class="left-box">
                <div class="page-title_big"><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></div>
                <h2 class="page-title_heading"><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h2>
            </div>
            <ul class="bread-crumb clearfix">
                <?php echo conat_the_breadcrumb(); ?>
            </ul>
        </div>
    </div>
</section>
<!-- End Page Title -->

<!-- Event Three -->
<section class="event-detail">
    <div class="auto-container">
        <div class="inner-container">
            <div class="event-detail_image">
                <?php the_post_thumbnail('full'); ?>
            </div>
            <div class="upper-box d-flex justify-content-between flex-wrap">
                <h2 class="event-detail_title"><?php the_title(); ?></h2>
                <div class="event-detail_author">
                	<?php $speaker_image = get_post_meta( get_the_id(), 'speaker_image', true );
					if($speaker_image) { ?>
                    <div class="event-detail_author-image">
                        <img src="<?php echo esc_url(wp_get_attachment_url($speaker_image['id'])); ?>" alt="<?php esc_attr_e('Speaker Image', 'conat'); ?>">
                    </div>
                    <?php } ?>
                    <div class="event-detail_author-name"><?php echo wp_kses(get_post_meta( get_the_id(), 'speaker_name', true ), true); ?>, <span><?php echo wp_kses(get_post_meta( get_the_id(), 'speaker_designation', true ), true); ?></span></div>
                    <?php if($vanue) { ?><div class="event-detail_author-location"><span><?php esc_html_e('Location:', 'conat'); ?></span> <?php echo wp_kses($vanue, true); ?></div><?php } ?>
                    <div class="event-detail_author-timing"><?php echo wp_kses($start_time, true); ?> - <?php echo wp_kses($end_time, true); ?></div>
                    
                    <?php if( get_post_meta( get_the_id(), 'audio', true ) == 'sc_audio' ) {
						$sc_id = get_post_meta( get_the_id(), 'sc_id', true );
						$auto_play = get_post_meta( get_the_id(), 'auto_play', true );
					?>
                    <a href="<?php echo esc_url('https://w.soundcloud.com/player/?visual=true&amp;url=https://api.soundcloud.com/tracks/'.esc_attr($sc_id).'&amp;show_artwork=true&amp;maxwidth=1020&amp;maxheight=1000&amp;auto_play='.esc_attr($auto_play).''); ?>" class="lightbox-audio mfp-iframe audio event-detail_author-icon flaticon-voice"></a>
                    <?php } else { ?>
                    <div class="event-detail_author-icon flaticon-voice"></div>
                    <?php } ?>
                </div>
            </div>
            
            <?php do_action( 'tribe_events_single_event_before_the_content' ) ?>
			<?php the_content();?>
            <?php do_action( 'tribe_events_single_event_after_the_content' ) ?>
            
            <div class="two-column">
				<?php do_action( 'tribe_events_single_event_before_the_meta' ) ?>
                <?php tribe_get_template_part( 'modules/meta' ); ?>
                <?php do_action( 'tribe_events_single_event_after_the_meta' ) ?>
            </div>
            
        </div>
    </div>
</section>
<!-- End Event Three -->
