<?php
/**
 * Single Event Meta (Organizer) Template
 *
 * Override this template in your own theme by creating a file at:
 * [your-theme]/tribe-events/modules/meta/details.php
 *
 * @package TribeEventsCalendar
 */

$organizer_ids = tribe_get_organizer_ids();
$multiple = count( $organizer_ids ) > 1;

$phone = tribe_get_organizer_phone();
$email = tribe_get_organizer_email();
$website = tribe_get_organizer_website_link();
?>

<div class="info-block single-item">
	<h4><?php echo tribe_get_organizer_label( ! $multiple ); ?></h4>
    
    <div class="info-inner">
        <ul class="info clearfix">
            <?php do_action( 'tribe_events_single_meta_organizer_section_start' );
    
            foreach ( $organizer_ids as $organizer ) {
                if ( ! $organizer ) {
                    continue;
                } ?>
                <li>
                	<span class="icon flaticon-user"></span>
                    <span class="tribe-organizer">
                        <?php esc_html_e('Name: ', 'conat'); echo tribe_get_organizer_link( $organizer ) ?>
                    </span>
                </li>
            <?php }
		
			if ( ! $multiple ) {
				if ( ! empty( $phone ) ) { ?>
					<li>
						<span class="icon flaticon-telephone"></span>
						<?php esc_html_e( 'Phone: ', 'conat' ) ?>
						<span class="tribe-organizer-tel">
							<?php echo esc_html( $phone ); ?>
						</span>
					</li>
				<?php }//end if
	
				if ( ! empty( $email ) ) { ?>
					<li>
						<span class="icon flaticon-email-1"></span>
						<?php esc_html_e( 'Email: ', 'conat' ) ?>
						<span class="tribe-organizer-email">
							<?php echo esc_html( $email ); ?>
						</span>
					</li>
				<?php }//end if
	
				if ( ! empty( $website ) ) { ?>
					<li>
						<span class="icon flaticon-link"></span>
						<?php esc_html_e( 'Website: ', 'conat' ) ?>
						<span class="tribe-organizer-url">
							<?php echo balanceTags($website); ?>
						</span>
					</li>
				<?php }//end if
			}//end if

			do_action( 'tribe_events_single_meta_organizer_section_end' ); ?>
        </ul>
    </div>
</div>
