<?php
$options = conat_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );

//Dark Logo
$logo = $options->get( 'logo' );
$logo_dimension = $options->get( 'logo_dimension' );

//Light Logo
$light_logo = $options->get( 'light_logo' );
$light_logo_dimension = $options->get( 'light_logo_dimension' );

//Sticky Logo
$sticky_logo = $options->get( 'sticky_logo' );
$sticky_logo_dimension = $options->get( 'sticky_logo_dimension' );

//Mobile Sidebar Logo
$mobile_logo = $options->get( 'mobile_logo' );
$mobile_logo_dimension = $options->get( 'mobile_logo_dimension' );

$logo_type = '';
$logo_text = '';
$logo_typography = ''; ?>

<div class="page-wrapper">
	
    <!-- Header Style One / Two -->
	<header class="main-header header-two">
        <?php if( $options->get('show_top_bar_v2') ){ ?>
		<!-- Header Top -->
		<div class="header-top">
			<div class="auto-container">
				<div class="d-flex justify-content-end">
                	<?php if($options->get( 'show_social_media_v2' )) {
					$icons = $options->get( 'icons_social_share' );
					if ( ! empty( $icons ) ) { ?>
					<!-- Social Box -->
					<div class="header-top_socials">
						<?php foreach ( $icons as $h_icon ) {
						$social_icons = json_decode( urldecode( conat_set( $h_icon, 'data' ) ) );
						if ( conat_set( $social_icons, 'enable' ) == '' ) {
							continue;
						}
						$icon_class = explode( '-', conat_set( $social_icons, 'icon' ) ); ?>
						<a href="<?php echo esc_url(conat_set( $social_icons, 'url' )); ?>" class="fa-brands <?php echo esc_attr( conat_set( $social_icons, 'icon' ) ); ?>"></a>
						<?php } ?>
					</div>
					<?php } } ?>
				</div>
			</div>
		</div>
        <?php } ?>
        
		<!-- Header Upper -->
		<div class="header-upper">
			<div class="auto-container">
				<div class="inner-container">
					<div class="d-flex justify-content-between align-items-center flex-wrap">
						
						<div class="logo-box">
							<div class="logo"><?php echo conat_logo( $logo_type, $logo, $logo_dimension, $logo_text, $logo_typography ); ?></div>
						</div>
						
						<div class="nav-outer">
							<!-- Main Menu -->
							<nav class="main-menu navbar-expand-md">
								<div class="navbar-header">
									<!-- Toggle Button -->    	
									<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
										<span class="icon-bar"></span>
										<span class="icon-bar"></span>
										<span class="icon-bar"></span>
									</button>
								</div>
								
								<div class="navbar-collapse scroll-nav collapse clearfix" id="navbarSupportedContent">
									<ul class="navigation clearfix">
										<?php wp_nav_menu( array( 'theme_location' => 'onepage_menu', 'container_id' => 'navbar-collapse-1',
											'container_class'=>'navbar-collapse collapse navbar-right',
											'menu_class'=>'nav navbar-nav',
											'fallback_cb'=>false,
											'items_wrap' => '%3$s',
											'container'=>false,
											'depth'=>'3',
											'walker'=> new Bootstrap_walker()
										) ); ?>
									</ul>
								</div>
							</nav>
						</div>
						
						<!-- Main Menu End-->
						<div class="outer-box d-flex align-items-center flex-wrap">
							<?php if( $options->get('show_search_v2') ){ ?>
                            <!-- Search Btn -->
                            <div class="search-box-btn search-box-outer"><span class="icon fa fa-search"></span></div>
                            <?php } ?>
                            
							<?php if( $options->get('show_button_v2') ){ ?>
                            <div class="appointmeny_button-box">
                                <?php echo conat_button($options->get('button_style_v2'), $options->get('button_name_v2'), $options->get('button_link_v2')); ?>
                            </div>
                            <?php } ?>

							<!-- Mobile Navigation Toggler -->
							<div class="mobile-nav-toggler"><span class="icon flaticon-menu"></span></div>
						</div>

					</div>
				</div>
			</div>
		</div>
		<!--End Header Upper-->
		
		<!-- Sticky Header  -->
		<div class="sticky-header">
			<div class="auto-container">
				<div class="inner-container d-flex justify-content-between align-items-center flex-wrap">
                    <!-- Logo -->
                    <div class="logo">
                        <?php echo conat_logo( $logo_type, $sticky_logo, $sticky_logo_dimension, $logo_text, $logo_typography ); ?>
                    </div>
                    
                    <!-- Right Box -->
                    <div class="right-box">
                        <!-- Main Menu -->
                        <nav class="main-menu">
                            <!--Keep This Empty / Menu will come through Javascript-->
                        </nav>
                        <!-- Main Menu End-->
                    </div>
    
                    <!-- Main Menu End-->
                    <div class="outer-box d-flex align-items-center flex-wrap">
                        <?php if( $options->get('show_search_v2') ){ ?>
                        <!-- Search Btn -->
                        <div class="search-box-btn search-box-outer"><span class="icon fa fa-search"></span></div>
                        <?php } ?>
                        
                        <?php if( $options->get('show_button_v2') ){ ?>
                        <div class="appointmeny_button-box">
                            <?php echo conat_button($options->get('button_style_v2'), $options->get('button_name_v2'), $options->get('button_link_v2')); ?>
                        </div>
                        <?php } ?>
    
                        <!-- Mobile Navigation Toggler -->
                        <div class="mobile-nav-toggler"><span class="icon flaticon-menu"></span></div>
                    </div>
                    
                </div>
            </div><!-- End Sticky Menu -->
		</div>
		
		<!-- Mobile Menu  -->
		<div class="mobile-menu">
			<div class="menu-backdrop"></div>
			<div class="close-btn"><span class="icon flaticon-cancel-1"></span></div>
			
			<nav class="menu-box">
				<div class="nav-logo"><?php echo conat_logo( $logo_type, $mobile_logo, $mobile_logo_dimension, $logo_text, $logo_typography ); ?></div>
				<div class="menu-outer"><!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header--></div>
			</nav>
		</div><!-- End Mobile Menu -->
	
	</header>
	<!-- End Main Header -->
    