<?php
/**
 * Footer Template File
 *
 * @package CONAT
 * @author  Noor Tech
 * @version 1.0
 */

$options = conat_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );

$footer_bg = $options->get( 'footer_background_v3' );
$footer_bg = conat_set( $footer_bg, 'url', CONAT_URI . 'assets/images/background/10.jpg' );

$footer_left = $options->get( 'pattern_left_image_v3' );
$footer_left = conat_set( $footer_left, 'url', CONAT_URI . 'assets/images/background/pattern-25.png' );

$footer_right = $options->get( 'pattern_right_image_v3' );
$footer_right = conat_set( $footer_right, 'url', CONAT_URI . 'assets/images/background/pattern-26.png' );
?>
	
    <!-- Footer Three -->
	<footer class="footer-three" <?php if ($footer_bg){ ?>style="background-image:url(<?php echo esc_url($footer_bg); ?>)"<?php } ?>>
		<?php if ($footer_left){ ?><div class="footer-three_pattern" style="background-image:url(<?php echo esc_url($footer_left); ?>)"></div><?php } ?>
		<?php if ($footer_right){ ?><div class="footer-three_pattern-two" style="background-image:url(<?php echo esc_url($footer_right); ?>)"></div><?php } ?>
		<div class="auto-container">
			<?php if ( is_active_sidebar( 'footer-sidebar-3' ) ) { ?>
			<!-- Widgets Section -->
			<div class="footer-three-widgets">
				<div class="row clearfix">
					<?php dynamic_sidebar( 'footer-sidebar-3' ); ?>
				</div>
			</div>
            <?php } ?>
		</div>

		<!-- Footer Bottom -->
		<div class="footer-bottom">
			<div class="auto-container">
            	<div class="row clearfix">
                    <div class="column col-lg-6 col-md-12 col-sm-12">
                        <div class="copyright"><?php echo wp_kses( $options->get( "copyrights", "Copyright &copy; ".date("Y")." conat. All Rights Reserved." ), $allowed_html ); ?></div>
                    </div>
                    
                    <?php if($options->get('show_footer_menu_v3')) { ?>
                    <!-- Column -->
                    <div class="column col-lg-6 col-md-12 col-sm-12">
                        <ul class="footer-bottom-nav">
                            <?php wp_nav_menu( array( 'theme_location' => 'footer_menu', 'container_id' => 'navbar-collapse-1',
                                'container_class'=>'navbar-collapse collapse navbar-right',
                                'menu_class'=>'nav navbar-nav',
                                'fallback_cb'=>false,
                                'items_wrap' => '%3$s',
                                'container'=>false,
                                'depth'=>'3',
                                'walker'=> new Bootstrap_walker()
                            ) ); ?>
                        </ul>
                    </div>
                    <?php } ?>
                </div>
			</div>
		</div>
	</footer>
	<!-- End Footer Three -->
    