<?php
/**
 * Footer Template  File
 *
 * @package CONAT
 * @author  Noor Tech
 * @version 1.0
 */

$options = conat_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );

$footer_bg = $options->get( 'footer_bg_v2' );
$footer_bg = conat_set( $footer_bg, 'url', CONAT_URI . 'assets/images/background/pattern-18.png' ); ?>
	
    <!--Main Footer-->
	<footer class="footer-two">
		<?php if ( is_active_sidebar( 'footer-sidebar-2' ) ) { ?>
            <div class="footer-two_icon-one" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-5.png'); ?>)"></div>
            <div class="footer-two_icon-two" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-5.png'); ?>)"></div>
            <div class="footer-two_icon-three" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-6.png'); ?>)"></div>
            <div class="footer-two_icon-four" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-6.png'); ?>)"></div>
            <div class="footer-two_icon-five" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-7.png'); ?>)"></div>
            <div class="footer-two_icon-six" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-8.png'); ?>)"></div>
            <div class="footer-two_icon-seven" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-9.png'); ?>)"></div>
            <div class="footer-two_icon-eight" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-10.png'); ?>)"></div>
            <div class="auto-container">
                <!--Widgets Section-->
                <div class="footer-two-widgets">
                    <div class="row clearfix">
                        <?php dynamic_sidebar( 'footer-sidebar-2' ); ?>
                    </div>
                </div>
            </div>
        <?php } ?>
        
		<!-- Footer Bottom -->
		<div class="footer-bottom">
			<div class="auto-container">
				<div class="row clearfix">
					<!-- Column -->
					<div class="column col-lg-6 col-md-12 col-sm-12">
						<div class="copyright"><?php echo wp_kses( $options->get( "copyrights", "&copy; Copyright ".date("Y")." noor_tech. All Rights Reserved." ), $allowed_html ); ?></div>
					</div>
                    
                    <?php if($options->get('show_footer_menu_v2')) { ?>
					<!-- Column -->
					<div class="column col-lg-6 col-md-12 col-sm-12">
                    	<ul class="footer-bottom-nav">
							<?php wp_nav_menu( array( 'theme_location' => 'footer_menu', 'container_id' => 'navbar-collapse-1',
                                'container_class'=>'navbar-collapse collapse navbar-right',
                                'menu_class'=>'nav navbar-nav',
                                'fallback_cb'=>false,
                                'items_wrap' => '%3$s',
                                'container'=>false,
                                'depth'=>'3',
                                'walker'=> new Bootstrap_walker()
                            ) ); ?>
                        </ul>
					</div>
                    <?php } ?>
				</div>
			</div>
		</div>
	</footer>
    