<?php

/**
 * Blog Content Template
 *
 * @package    WordPress
 * @subpackage CONAT
 * @author  Noor Tech
 * @version    1.0
 */

if ( class_exists( 'Conat_Resizer' ) ) {
	$img_obj = new Conat_Resizer();
} else {
	$img_obj = array();
}

$options = conat_WSH()->option();

$allowed_tags = wp_kses_allowed_html('post');
global $post; ?>

<div <?php post_class(); ?>>
	
    <!-- News Block -->
    <div class="news-block_one">
        <div class="news-block_one-inner">
            <?php if (has_post_thumbnail()){ ?>
            <div class="news-block_one-image">
                <a href="<?php echo esc_url(the_permalink(get_the_id())); ?>"><?php the_post_thumbnail('full'); ?></a>
                <?php the_post_thumbnail('full'); ?>
            </div>
            <?php } ?>
            <div class="news-block_one-content">
                <div class="news-block_one-date"><?php echo get_the_date(); ?></div>
                <ul class="news-block_one-meta">
                    <li><span class="icon fa-regular fa-calendar fa-fw"></span><?php esc_html_e('by', 'conat'); ?> <?php the_author(); ?></li>
                    <li><span class="icon fa-solid fa-comments fa-fw"></span><?php comments_number( '(0) Comments', '(1) Comment', '(%) Comments' ); ?></li>
                </ul>
                <h4 class="news-block_one-title"><a href="<?php echo esc_url(the_permalink(get_the_id())); ?>"><?php the_title(); ?></a></h4>
                <div class="news-block_one-text"><?php the_excerpt(); ?></div>
                <a href="<?php echo esc_url(the_permalink(get_the_id())); ?>" class="news-block_one-more"><?php esc_html_e('Read More', 'conat'); ?></a>
            </div>
        </div>
    </div>
    
</div>