<?php
/**
 * Banner Template
 *
 * @package    WordPress
 * @subpackage ThemeRange
 * @author  Noor Tech
 * @version    1.0
 */

if ( $data->get( 'enable_banner' ) AND $data->get( 'banner_type' ) == 'e' AND ! empty( $data->get( 'banner_elementor' ) ) ) {
	echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $data->get( 'banner_elementor' ) );

	return false;
} ?>

<?php if ( $data->get( 'enable_banner' ) ) : ?>
<!-- Page Title -->
<section class="page-title" <?php if ($data->get( 'banner' )){ ?>style="background-image: url(<?php echo esc_url( $data->get( 'banner' ) ); ?>)"<?php } ?>>
    <div class="auto-container">
        <div class="d-flex justify-content-between align-items-center flex-wrap">
            <div class="left-box">
                <div class="page-title_big"><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></div>
                <h2 class="page-title_heading"><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h2>
            </div>
            <ul class="bread-crumb clearfix">
                <?php echo conat_the_breadcrumb(); ?>
            </ul>
        </div>
    </div>
</section>
<!-- End Page Title -->
<?php endif; ?>