<?php
/**
 * Blog Post Main File.
 *
 * @package CONAT
 * @author  Noor Tech
 * @version 1.0
 */

get_header();
$data    = \CONAT\Includes\Classes\Common::instance()->data( 'single' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-lg-12 col-md-12 col-sm-12' : 'col-lg-8 col-md-12 col-sm-12">';
$options = conat_WSH()->option();

if ( class_exists( '\Elementor\Plugin' ) && $data->get( 'tpl-type' ) == 'e') {
	
	while(have_posts()) {
	   the_post();
	   the_content();
    }

} else { ?>

<!-- Page Title -->
<section class="page-title" <?php if ($data->get( 'banner' )){ ?>style="background-image: url(<?php echo esc_url( $data->get( 'banner' ) ); ?>)"<?php } ?>>
    <div class="auto-container">
        <div class="d-flex justify-content-between align-items-center flex-wrap">
            <div class="left-box">
                <div class="page-title_big"><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></div>
                <h2 class="page-title_heading"><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h2>
            </div>
            <ul class="bread-crumb clearfix">
                <?php echo conat_the_breadcrumb(); ?>
            </ul>
        </div>
    </div>
</section>
<!-- End Page Title -->

<!-- Sidebar Page Container -->
<div class="sidebar-page-container">
    <div class="auto-container">
        <div class="row clearfix">
        	<?php
				if ( $data->get( 'layout' ) == 'left' ) {
					do_action( 'conat_sidebar', $data );
				}
			?>
            
            <div class="content-side <?php echo esc_attr( $class ); ?>">
				<?php global $post;
				while ( have_posts() ) : the_post(); ?>
                <div class="thm-unit-test">
					<div class="blog-detail">
                    	
                        <div class="blog-detail_inner">
                        	<?php if (has_post_thumbnail()){ ?>
							<div class="blog-detail_image">
								<?php the_post_thumbnail('full'); ?>
							</div>
                            <?php } ?>
                            
                            <div class="blog-detail_content">
								<div class="blog-detail_date"><?php echo get_the_date('d F Y'); ?></div>
								<ul class="blog-detail_meta">
									<li><span class="icon fa-regular fa-calendar fa-fw"></span><?php esc_html_e('by', 'conat'); ?> <?php the_author(); ?></li>
									<li><span class="icon fa-solid fa-comments fa-fw"></span><?php comments_number( '(0) Comments', '(1) Comment', '(%) Comments' ); ?></li>
								</ul>
								<h3 class="blog-detail_heading"><?php the_title(); ?></h3>
                                
                                <?php the_content(); ?>
                                <div class="clearfix"></div>
                                
                                <?php if ($options->get( 'single_post_tag' ) or $options->get( 'single_post_share_us' )){ ?>
								<!-- Post Share Options-->
								<div class="post-share-options">
									<div class="post-share-inner d-flex justify-content-between align-items-center flex-wrap">
                                        <?php if( $options->get( 'single_post_tag' ) ): ?>
										<ul class="tags">
                                            <li><span><?php esc_html_e('Tags:', 'conat'); ?></span></li>
                                            <?php the_tags('<li>', ',</li><li> ', '</li>'); ?>
                                        </ul>
                                        <?php endif; ?>
                                        
                                        <?php if( $options->get( 'single_post_share_us' ) ):
											echo wp_kses(conat_share_us(get_the_id(), $post->post_name ), true);
										endif; ?>
									</div>
								</div>
                                <?php } ?>
							</div>
                            
                            <?php if( $options->get( 'single_post_author' ) ):  ?>
							<!-- Author Box -->
							<div class="blog-author-box">
								<div class="author-inner">
									<?php if($avatar = get_avatar(get_the_author_meta('ID')) !== FALSE): ?>
                                    <div class="thumb"><?php echo get_avatar(get_the_author_meta('ID'), 170); ?></div>
                                    <?php endif; ?>
									<div class="name"><?php the_author(); ?></div>
									<div class="text"><?php the_author_meta( 'description', get_the_author_meta('ID') ); ?></div>
								</div>
							</div>
                            <?php endif; ?>

							<!-- Comments Area -->
							<?php comments_template(); ?>

						</div>
                        
					</div>
                </div>
                <?php endwhile; ?>
            </div>
            
        	<?php
				if ( $data->get( 'layout' ) == 'right' ) {
					do_action( 'conat_sidebar', $data );
				}
			?>
        </div>
    </div>
</div>
<!--End blog area--> 

<?php
}
get_footer();
