<?php get_header();
$data = \CONAT\Includes\Classes\Common::instance()->data('single-doctor')->get(); ?>

<!-- Page Title -->
<section class="page-title" <?php if ($data->get( 'banner' )){ ?>style="background-image: url(<?php echo esc_url( $data->get( 'banner' ) ); ?>)"<?php } ?>>
    <div class="auto-container">
        <div class="d-flex justify-content-between align-items-center flex-wrap">
            <div class="left-box">
                <div class="page-title_big"><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></div>
                <h2 class="page-title_heading"><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h2>
            </div>
            <ul class="bread-crumb clearfix">
                <?php echo conat_the_breadcrumb(); ?>
            </ul>
        </div>
    </div>
</section>
<!-- End Page Title -->

<?php while (have_posts()) : the_post(); ?>

<!-- Speaker Detail -->
<section class="speaker-detail">
    <div class="auto-container">
        <div class="row clearfix">
            <!-- Author Column -->
            <div class="speaker-detail_author-column col-lg-4 col-md-6 col-sm-12">
                <div class="speaker-detail_author-inner">
                    <div class="speaker-detail_author-pattern" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/background/pattern-27.png'); ?>)"></div>
                    <div class="speaker-detail_author-image">
                        <?php if (has_post_thumbnail()){
							the_post_thumbnail('full');
						} ?>
                        
                        <?php $icons = get_post_meta( get_the_id(), 'social_profile', true );
						if ( ! empty( $icons ) ) : ?>
						<!-- Social Box -->
						<div class="speaker-detail_social-list">
							<?php foreach ( $icons as $h_icon ) :
								$social_icons = json_decode( urldecode( conat_set( $h_icon, 'data' ) ) );
								if ( conat_set( $social_icons, 'enable' ) == '' ) {
									continue;
								}
								$icon_class = explode( '-', conat_set( $social_icons, 'icon' ) );
							?>
							<a href="<?php echo conat_set( $social_icons, 'url' ); ?>" class="fa-brands <?php echo esc_attr( conat_set( $social_icons, 'icon' ) ); ?>" target="_blank"></a>
							<?php endforeach; ?>
						</div>
						<?php endif; ?>
                    </div>
                    <div class="speaker-detail_author-content">
                        <h4 class="speaker-detail_title"><?php the_title(); ?></h4>
                        
                        <?php if (get_post_meta( get_the_id(), 'designation', true )){ ?>
                        <div class="speaker-detail_designation"><?php echo wp_kses(get_post_meta( get_the_id(), 'designation', true ), true); ?></div>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <!-- Content Column -->
            <div class="content-column col-lg-8 col-md-12 col-sm-12">
                <h2 class="speaker-detail_subtitle"><?php echo wp_kses(get_post_meta( get_the_id(), 'title', true ), true); ?></h2>
                <?php echo wp_kses(get_post_meta( get_the_id(), 'content', true ), true); ?>
                <h3 class="speaker-detail_subtitle"><?php esc_html_e('Contact info', 'conat'); ?></h3>
                <div class="row clearfix">
                    <div class="col-lg-6 col-md-6 col-sm-12">
                        <ul class="speaker-detail_info">
                        	<?php if (get_post_meta( get_the_id(), 'speciality', true )){ ?>
                            <li><span><?php esc_html_e('Speciality:', 'conat'); ?></span> <?php echo wp_kses(get_post_meta( get_the_id(), 'speciality', true ), true); ?></li>
                            <?php } ?>
                            
                            <?php if (get_post_meta( get_the_id(), 'experience', true )){ ?>
                            <li><span><?php esc_html_e('Experience:', 'conat'); ?></span> <?php echo wp_kses(get_post_meta( get_the_id(), 'experience', true ), true); ?></li>
                            <?php } ?>
                            
                            <?php if (get_post_meta( get_the_id(), 'phone', true )){ ?>
                            <li><span><?php esc_html_e('Phone:', 'conat'); ?></span> <?php echo wp_kses(get_post_meta( get_the_id(), 'phone', true ), true); ?></li>
                            <?php } ?>
                        </ul>
                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-12">
                        <ul class="speaker-detail_info">
                        	<?php if (get_post_meta( get_the_id(), 'company', true )){ ?>
                            <li><span><?php esc_html_e('Company:', 'conat'); ?></span> <?php echo wp_kses(get_post_meta( get_the_id(), 'company', true ), true); ?></li>
                            <?php } ?>
                            
                            <?php if (get_post_meta( get_the_id(), 'email', true )){ ?>
                            <li><span><?php esc_html_e('Email:', 'conat'); ?></span> <?php echo sanitize_email(get_post_meta( get_the_id(), 'email', true )); ?></li>
                            <?php } ?>
                            
                            <?php if (get_post_meta( get_the_id(), 'fax', true )){ ?>
                            <li><span><?php esc_html_e('Fax:', 'conat'); ?></span> <?php echo wp_kses(get_post_meta( get_the_id(), 'fax', true ), true); ?></li>
                            <?php } ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- End Speaker Detail -->

<?php the_content(); ?>

<?php endwhile; ?>

<?php get_footer(); ?>