<?php
/**
 * Tag Main File.
 *
 * @package CONAT
 * @author  Noor Tech
 * @version 1.0
 */

get_header();
global $wp_query;
$data = \CONAT\Includes\Classes\Common::instance()->data( 'search' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
$layout = ( $layout ) ? $layout : 'right';
$sidebar = ( $sidebar ) ? $sidebar : 'default-sidebar';
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-xs-12 col-sm-12 col-md-12' : 'col-xs-12 col-sm-12 col-md-12 col-lg-8';
if ( class_exists( '\Elementor\Plugin' ) AND $data->get( 'tpl-type' ) == 'e' AND $data->get( 'tpl-elementor' ) ) {
	echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $data->get( 'tpl-elementor' ) );
} else { ?>
	
<?php if ( class_exists( '\Elementor\Plugin' )): ?>
	<?php do_action( 'conat_banner', $data ); ?>
<?php else: ?>
<!-- Page Title -->
<section class="page-title" <?php if ($data->get( 'banner' )){ ?>style="background-image: url(<?php echo esc_url( $data->get( 'banner' ) ); ?>)"<?php } ?>>
    <div class="auto-container">
        <div class="d-flex justify-content-between align-items-center flex-wrap">
            <div class="left-box">
                <div class="page-title_big"><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></div>
                <h2 class="page-title_heading"><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h2>
            </div>
            <ul class="bread-crumb clearfix">
                <?php echo conat_the_breadcrumb(); ?>
            </ul>
        </div>
    </div>
</section>
<!-- End Page Title -->
<?php endif; ?>

<!-- Sidebar Page Container -->
<div class="sidebar-page-container">
    <div class="auto-container">
        <div class="row clearfix">
			<?php
				if ( $data->get( 'layout' ) == 'left' ) {
					do_action( 'conat_sidebar', $data );
				}
			?>
            
			<div class="content-side <?php echo esc_attr( $class ); ?>">
				<?php if( have_posts() ) : ?>
                    <div class="thm-unit-test">
                        <?php
                            while ( have_posts() ) :
                                the_post();
                                conat_template_load( 'templates/blog/blog.php', compact( 'data' ) );
                            endwhile;
                            wp_reset_postdata();
                        ?>
                    </div>
                
                    <!--Pagination-->
                    <?php conat_the_pagination( $wp_query->max_num_pages ); ?>

				<?php else : ?>
				
				<div class="search-notfound">
					<h4><?php printf(esc_html__( 'No result found for "%s"', 'conat' ), get_search_query()); ?></h4>
					<p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'conat' ); ?></p>
					<div class="sidebar search-search-form">
						<?php get_search_form(); ?>
					</div>
				</div>

				<?php endif; ?>
			</div>
            
			<?php
				if ( $data->get( 'layout' ) == 'right' ) {
					do_action( 'conat_sidebar', $data );
				}
			?>
		</div>
	</div>
</div> 
<!--End blog area-->
<?php
}
get_footer();

