<?php
/**
 * Default Template Main File.
 *
 * @package CONAT
 * @author  Noor Tech
 * @version 1.0
 */

get_header();
$data  = \CONAT\Includes\Classes\Common::instance()->data( 'single' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-xs-12 col-sm-12 col-md-12' : 'col-lg-8 col-md-12 col-sm-12';
?>

<?php if ( class_exists( '\Elementor\Plugin' )) : ?>
	<?php do_action( 'conat_banner', $data ); ?>
<?php else: ?>
<!-- Page Title -->
<section class="page-title" <?php if ($data->get( 'banner' )){ ?>style="background-image: url(<?php echo esc_url( $data->get( 'banner' ) ); ?>)"<?php } ?>>
    <div class="auto-container">
        <div class="d-flex justify-content-between align-items-center flex-wrap">
            <div class="left-box">
                <div class="page-title_big"><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></div>
                <h2 class="page-title_heading"><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h2>
            </div>
            <ul class="bread-crumb clearfix">
                <?php echo conat_the_breadcrumb(); ?>
            </ul>
        </div>
    </div>
</section>
<!-- End Page Title -->
<?php endif; ?>

<!-- Sidebar Page Container -->
<div class="sidebar-page-container">
    <div class="auto-container">
        <div class="row clearfix">
        	
			<!--Sidebar Start-->
        	<?php
				if ( $data->get( 'layout' ) == 'left' ) {
					do_action( 'conat_sidebar', $data );
				}
            ?>
            
            <div class="content-side <?php echo esc_attr( $class ); ?>">
                <div class="blog-classic">
                    <div class="thm-unit-test">
                        <?php while ( have_posts() ): the_post(); ?>
                            <?php the_content(); ?>
                        <?php endwhile; ?>
                        <div class="clearfix"></div>
                        
                        <?php
                        $defaults = array(
                            'before' => '<div class="paginate-links">' . esc_html__( 'Pages:', 'conat' ),
                            'after'  => '</div>',
        
                        );
                        wp_link_pages( $defaults ); ?>
                        
                        <?php comments_template() ?>
                    </div>
            	</div>
            </div>
        	
			<!--Sidebar Start-->
            <?php
				if ( $layout == 'right' ) {
					$data->set('sidebar', 'default-sidebar');
					do_action( 'conat_sidebar', $data );
				}
            ?>
        
        </div>
	</div>
</div>
<!-- blog section with pagination -->

<?php get_footer(); ?>
