<?php
/**
 * Blog Main File.
 *
 * @package CONAT
 * @author  Noor Tech
 * @version 1.0
 */

get_header();
global $wp_query;
$data  = \CONAT\Includes\Classes\Common::instance()->data( 'blog' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
$layout = ( $layout ) ? $layout : 'right';
$sidebar = ( $sidebar ) ? $sidebar : 'default-sidebar';
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-xs-12 col-sm-12 col-md-12' : 'col-lg-8 col-md-12 col-sm-12';
if ( class_exists( '\Elementor\Plugin' ) AND $data->get( 'tpl-type' ) == 'e' AND $data->get( 'tpl-elementor' ) ) {
	echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $data->get( 'tpl-elementor' ) );
} else {
?>
	
<?php if ( class_exists( '\Elementor\Plugin' )):?>
	<?php do_action( 'conat_banner', $data );?>
<?php else: ?>
<!-- Page Title -->
<section class="page-title" <?php if ($data->get( 'banner' )){ ?>style="background-image: url(<?php echo esc_url( $data->get( 'banner' ) ); ?>)"<?php } ?>>
    <div class="auto-container">
        <div class="d-flex justify-content-between align-items-center flex-wrap">
            <div class="left-box">
                <div class="page-title_big"><?php echo esc_html_e( 'Blog', 'conat' ); ?></div>
                <h2 class="page-title_heading"><?php echo esc_html_e( 'Blog', 'conat' ); ?></h2>
            </div>
            <ul class="bread-crumb clearfix">
                <?php echo conat_the_breadcrumb(); ?>
            </ul>
        </div>
    </div>
</section>
<!-- End Page Title -->
<?php endif;?>

<!-- Sidebar Page Container -->
<div class="sidebar-page-container">
    <div class="auto-container">
        <div class="row clearfix">
			<!--Sidebar Start-->
			<?php
				if ( $data->get( 'layout' ) == 'left' ) {
					do_action( 'conat_sidebar', $data );
				}
			?>

			<div class="content-side <?php echo esc_attr( $class ); ?>">
				<div class="blog-classic">
                    <div class="thm-unit-test">
                        <?php
                            while ( have_posts() ) :
                                the_post();
                                conat_template_load( 'templates/blog/blog.php', compact( 'data' ) );
                            endwhile;
                            wp_reset_postdata();
                        ?>
                    </div>
                
                    <!--Pagination-->
                    <?php conat_the_pagination( $wp_query->max_num_pages ); ?>
				</div>        
			</div>
        	
			<!--Sidebar Start-->
			<?php
				if ( $data->get( 'layout' ) == 'right' ) {
					do_action( 'conat_sidebar', $data );
				}
			?>
		</div>
	</div>
</div> 
<!--End blog area--> 
<?php
}
get_footer();
