<?php
return array(
	'title'      => esc_html__( 'WooCommerce Settings', 'conat' ),
	'id'         => 'woocommerce_setting',
	'desc'       => '',
	'fields'     => array(
		//Banner Background
		array(
			'id'       => 'shop_banner_bg',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Background Image', 'conat' ),
			'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/background/11.jpg' ),
		),
		
		//Layout
		array(
			'id'       => 'woocommerce_sidebar_layout',
			'type'     => 'image_select',
			'title'    => esc_html__( 'Layout', 'conat' ),
			'subtitle' => esc_html__( 'Select main content and sidebar alignment.', 'conat' ),
			'options'  => array(

				'left'  => array(
					'alt' => esc_html__( 'Left Sidebar', 'conat' ),
					'img' => get_template_directory_uri() . '/assets/images/redux/2cl.png',
				),
				'full'  => array(
					'alt' => esc_html__( 'Full Width', 'conat' ),
					'img' => get_template_directory_uri() . '/assets/images/redux/1col.png',
				),
				'right' => array(
					'alt' => esc_html__( 'Right Sidebar', 'conat' ),
					'img' => get_template_directory_uri() . '/assets/images/redux/2cr.png',
				),
			),

			'default' => 'right',
		),

		array(
			'id'       => 'woocommerce_page_sidebar',
			'type'     => 'select',
			'title'    => esc_html__( 'Sidebar', 'conat' ),
			'desc'     => esc_html__( 'Select sidebar to show at blog listing page', 'conat' ),
			'required' => array(
				array( 'woocommerce_sidebar_layout', '=', array( 'left', 'right' ) ),
			),
			'options'  => conat_get_sidebars(),
		),
		
		array(
			'id'       => 'woocommerce_default_ed',
			'type'     => 'section',
			'indent'   => false,
			'required' => [ 'woocommerce_source_type', '=', 'd' ],
		),
	),
);
