<?php

return array(
	'title'      => esc_html__( 'Single Post Settings', 'conat' ),
	'id'         => 'single_post_setting',
	'desc'       => '',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'      => 'single_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Single Post Source Type', 'conat' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'conat' ),
				'e' => esc_html__( 'Elementor', 'conat' ),
			),
			'default' => 'd',
		),

		array(
			'id'       => 'single_default_st',
			'type'     => 'section',
			'title'    => esc_html__( 'Post Default', 'conat' ),
			'indent'   => true,
			'required' => [ 'single_source_type', '=', 'd' ],
		),
		
		//Tags
		array(
			'id'      => 'single_post_tag',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Tags', 'conat' ),
			'desc'    => esc_html__( 'Enable to show tags on post detail page.', 'conat' ),
			'default' => false,
		),
		
		//Post Share
		array(
			'id'      => 'single_post_share_us',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Social Share Icons', 'conat' ),
			'desc'    => esc_html__( 'Enable to show author box on post detail page.', 'conat' ),
			'default' => false,
		),
		array(
			'id'      => 'facebook_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Facebook Post Share', 'conat' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Facebook', 'conat' ),
			'default' => false,
			'required' => array( 'single_post_share_us', '=', true ),
		),
		array(
			'id'      => 'twitter_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Twitter Post Share', 'conat' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Twitter', 'conat' ),
			'default' => false,
			'required' => array( 'single_post_share_us', '=', true ),
		),
		array(
			'id'      => 'linkedin_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Linkedin Post Share', 'conat' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Linkedin', 'conat' ),
			'default' => false,
			'required' => array( 'single_post_share_us', '=', true ),
		),
		array(
			'id'      => 'pinterest_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Pinterest Post Share', 'conat' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Pinterest', 'conat' ),
			'default' => false,
			'required' => array( 'single_post_share_us', '=', true ),
		),
		array(
			'id'      => 'reddit_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Reddit Post Share', 'conat' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Reddit', 'conat' ),
			'default' => false,
			'required' => array( 'single_post_share_us', '=', true ),
		),
		array(
			'id'      => 'tumblr_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Tumblr Post Share', 'conat' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Tumblr', 'conat' ),
			'default' => false,
			'required' => array( 'single_post_share_us', '=', true ),
		),
		array(
			'id'      => 'digg_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Digg Post Share', 'conat' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Digg', 'conat' ),
			'default' => false,
			'required' => array( 'single_post_share_us', '=', true ),
		),
		
		//Author
		array(
			'id'      => 'single_post_author',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Author', 'conat' ),
			'desc'    => esc_html__( 'Enable to show author on post detail page.', 'conat' ),
			'default' => false,
		),
		
		array(
			'id'       => 'single_section_default_ed',
			'type'     => 'section',
			'indent'   => false,
			'required' => [ 'single_source_type', '=', 'd' ],
		),
	),
);
