<?php
return array(
	'title'      => esc_html__( 'Header Setting', 'conat' ),
	'id'         => 'headers_setting',
	'desc'       => '',
	'subsection' => false,
	'fields'     => array(
		array(
			'id'      => 'header_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Header Source Type', 'conat' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'conat' ),
				'e' => esc_html__( 'Elementor', 'conat' ),
			),
			'default' => 'd',
		),
		array(
			'id'       => 'header_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'conat' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
				'posts_per_page'	=> -1
			],
			'required' => [ 'header_source_type', '=', 'e' ],
		),
		array(
			'id'       => 'header_style_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Settings', 'conat' ),
			'required' => array( 'header_source_type', '=', 'd' ),
		),

		//Header Settings
		array(
		    'id'       => 'header_style_settings',
		    'type'     => 'image_select',
		    'title'    => esc_html__( 'Choose Header Styles', 'conat' ),
		    'options'  => array(
			    'header_v1'  => array(
				    'alt' => esc_html__( 'Header Style / OnePage 1', 'conat' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header1.png',
			    ),
			    'header_v2'  => array(
				    'alt' => esc_html__( 'Header Style / OnePage 2', 'conat' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header2.png',
			    ),
			),
			'required' => array( 'header_source_type', '=', 'd' ),
			'default' => 'header_v1',
	    ),

		/***********************************************************************
								Header Version 1 Start
		************************************************************************/
		array(
			'id'       => 'header_v1_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style / OnePage One Settings', 'conat' ),
			'required' => array( 'header_style_settings', '=', 'header_v1' ),
		),
		
		//Search
		array(
		    'id'       => 'show_search_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Search', 'conat' ),
		    'desc'     => esc_html__( 'Enable/Disable Search.', 'conat' ),
			'default'  => '',
		    'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		
		//Cart
		array(
		    'id'       => 'show_cart_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Cart', 'conat' ),
		    'desc'     => esc_html__( 'Enable/Disable Cart.', 'conat' ),
			'default'  => '',
		    'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		
		//Button
		array(
		    'id'       => 'show_button_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Button', 'conat' ),
		    'desc'     => esc_html__( 'Enable/Disable Button.', 'conat' ),
			'default'  => '',
		    'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		array(
		    'id'       => 'button_style_v1',
		    'type'     => 'select',
		    'default' => 'one',
		    'title'    => esc_html__( 'Button Style', 'conat' ),
		    'options'  => conat_button_style(),
			'required' => array( 'show_button_v1', '=', true ),
	    ),
		array(
		    'id'       => 'button_name_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Button Name', 'conat' ),
			'required' => array( 'show_button_v1', '=', true ),
		),
		array(
		    'id'       => 'button_link_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Button Link', 'conat' ),
			'required' => array( 'show_button_v1', '=', true ),
		),
		
		/***********************************************************************
								Header Version 2 Start
		************************************************************************/
		array(
			'id'       => 'header_v2_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style / OnePage Two Settings', 'conat' ),
			'required' => array( 'header_style_settings', '=', 'header_v2' ),
		),
		
		//Top Bar
		array(
		    'id'       => 'show_top_bar_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Show Top Bar', 'conat' ),
		    'desc'     => esc_html__( 'Enable/Disable Show Top Bar.', 'conat' ),
			'default'  => '',
		    'required' => array( 'header_style_settings', '=', 'header_v2' ),
	    ),
				
		//Social Media
		array(
		    'id'       => 'show_social_media_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Social Media', 'conat' ),
		    'desc'     => esc_html__( 'Enable/Disable Social Media.', 'conat' ),
			'default'  => '',
			'required' => array( 'show_top_bar_v2', '=', true ),
	    ),
		
		//Search
		array(
		    'id'       => 'show_search_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Search Icon', 'conat' ),
		    'desc'     => esc_html__( 'Enable/Disable Search Icon.', 'conat' ),
			'default'  => '',
		    'required' => array( 'header_style_settings', '=', 'header_v2' ),
	    ),
		
		//Cart
		array(
		    'id'       => 'show_cart_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Cart', 'conat' ),
		    'desc'     => esc_html__( 'Enable/Disable Cart.', 'conat' ),
			'default'  => '',
		    'required' => array( 'header_style_settings', '=', 'header_v2' ),
	    ),
		
		//Button
		array(
		    'id'       => 'show_button_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Button', 'conat' ),
		    'desc'     => esc_html__( 'Enable/Disable Button.', 'conat' ),
			'default'  => '',
		    'required' => array( 'header_style_settings', '=', 'header_v2' ),
	    ),
		array(
		    'id'       => 'button_style_v2',
		    'type'     => 'select',
		    'default' => 'one',
		    'title'    => esc_html__( 'Button Style', 'conat' ),
		    'options'  => conat_button_style(),
			'required' => array( 'show_button_v2', '=', true ),
	    ),
		array(
		    'id'       => 'button_name_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Button Name', 'conat' ),
			'required' => array( 'show_button_v2', '=', true ),
		),
		array(
		    'id'       => 'button_link_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Button Link', 'conat' ),
			'required' => array( 'show_button_v2', '=', true ),
		),
		
		array(
			'id'       => 'header_style_section_end',
			'type'     => 'section',
			'indent'      => false,
			'required' => [ 'header_source_type', '=', 'd' ],
		),
	),
);
