<?php return array(
	'title'      => esc_html__( 'Footer Setting', 'conat' ),
	'id'         => 'footer_setting',
	'desc'       => '',
	'subsection' => false,
	'fields'     => array(
		array(
			'id'      => 'footer_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Footer Source Type', 'conat' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'conat' ),
				'e' => esc_html__( 'Elementor', 'conat' ),
			),
			'default' => 'd',
		),
		
		//Copyrights
		array(
			'id'      => 'copyrights',
			'type'    => 'textarea',
			'title'   => __( 'Copyrights', 'conat' ),
			'required' => array( 'footer_source_type', '=', 'd' ),
		),
		
		array(
			'id'       => 'footer_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'conat' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
				'posts_per_page'	=> -1
			],
			'required' => [ 'footer_source_type', '=', 'e' ],
		),
		array(
			'id'       => 'footer_style_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Settings', 'conat' ),
			'required' => array( 'footer_source_type', '=', 'd' ),
		),
		array(
		    'id'       => 'footer_style_settings',
		    'type'     => 'image_select',
		    'title'    => esc_html__( 'Choose Footer Styles', 'conat' ),
		    'subtitle' => esc_html__( 'Choose Footer Styles', 'conat' ),
		    'options'  => array(
			    'footer_v1'  => array(
				    'alt' => esc_html__( 'Footer Style 1', 'conat' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer1.png',
			    ),
			    'footer_v2'  => array(
				    'alt' => esc_html__( 'Footer Style 2', 'conat' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer2.png',
			    ),
			    'footer_v3'  => array(
				    'alt' => esc_html__( 'Footer Style 3', 'conat' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer3.png',
			    ),
			),
			'required' => array( 'footer_source_type', '=', 'd' ),
			'default' => 'footer_v1',
	    ),
		
		/***********************************************************************
								Footer Version 1 Start
		************************************************************************/
		array(
			'id'       => 'footer_v1_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Style One Settings', 'conat' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
		),
		
		//Footer Style
		array(
		    'id'       => 'show_footer_style_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Footer Style', 'conat' ),
		    'desc'     => esc_html__( 'Enable/Disable Footer Style for Newsletter adjustment.', 'conat' ),
			'default'  => '',
		    'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		
		//Footer Menu
		array(
		    'id'       => 'show_footer_menu_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Footer Menu', 'conat' ),
		    'desc'     => esc_html__( 'Enable/Disable Footer Menu.', 'conat' ),
			'default'  => '',
			'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
	    ),
		
		/***********************************************************************
								Footer Version 2 Start
		************************************************************************/
		array(
			'id'       => 'footer_v2_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Style Two Settings', 'conat' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v2' ),
		),
		
		//Footer Menu
		array(
		    'id'       => 'show_footer_menu_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Footer Menu', 'conat' ),
		    'desc'     => esc_html__( 'Enable/Disable Footer Menu.', 'conat' ),
			'default'  => '',
			'required' => array( 'footer_style_settings', '=', 'footer_v2' ),
	    ),
		
		/***********************************************************************
								Footer Version 3 Start
		************************************************************************/
		array(
			'id'       => 'footer_v3_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Style Three Settings', 'conat' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v3' ),
		),
		
		//Footer Background
		array(
			'id'       => 'footer_background_v3',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Background Image', 'conat' ),
			'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/background/10.jpg' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v3' ),
		),
		
		//Pattern Left Image
		array(
			'id'       => 'pattern_left_image_v3',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Pattern Left Image', 'conat' ),
			'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/background/pattern-25.png' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v3' ),
		),
		
		//Pattern Right Image
		array(
			'id'       => 'pattern_right_image_v3',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Pattern Right Image', 'conat' ),
			'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/background/pattern-26.png' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v3' ),
		),
		
		//Footer Menu
		array(
		    'id'       => 'show_footer_menu_v3',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Footer Menu', 'conat' ),
		    'desc'     => esc_html__( 'Enable/Disable Footer Menu.', 'conat' ),
			'default'  => '',
			'required' => array( 'footer_style_settings', '=', 'footer_v3' ),
	    ),
		
		array(
			'id'       => 'footer_default_ed',
			'type'     => 'section',
			'indent'   => false,
			'required' => [ 'footer_source_type', '=', 'd' ],
		),
	),
);
