<?php
/**
 * The header for our theme
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @package CONAT
 * @since   1.0
 * @version 1.0
 */
$options = conat_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );
$favicon = $options->get( 'image_favicon' );
$favicon = conat_set( $favicon, 'url', '' ); ?>

<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
    
	<?php echo conat_favicon($favicon); ?>
    
	<!-- responsive meta -->
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!-- For IE -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php wp_head(); ?>
</head>


<body <?php body_class(); ?>> 

<?php
if ( ! function_exists( 'wp_body_open' ) ) {
		function wp_body_open() {
			do_action( 'wp_body_open' );
		}
}?>
    
<div class="page-wrapper">

	<?php if( $options->get( 'theme_preloader' ) ):?>
    <!-- Preloader -->
    <div class="preloader"></div>
    <!-- End Preloader -->
    <?php endif; ?>
	