<?php require_once get_template_directory() . '/includes/loader.php';

add_action( 'after_setup_theme', 'conat_setup_theme' );
add_action( 'after_setup_theme', 'conat_load_default_hooks' );

/*** Activate Theme ***/
add_action('admin_init', 'conat_theme_activation');
function conat_theme_activation(){
	global $pagenow;
	if( is_admin() && 'themes.php' == $pagenow && isset($_GET['activated']) )
	{
		$elementor_cpt_support = get_option( 'elementor_cpt_support', array( 'page', 'post' ) );
		
		if( !in_array( 'speaker', $elementor_cpt_support ) ){
			$elementor_cpt_support[] = 'speaker';
		}
		if( !in_array( 'tribe_events', $elementor_cpt_support ) ){
			$elementor_cpt_support[] = 'tribe_events';
		}
		update_option( 'elementor_cpt_support', $elementor_cpt_support );
	}
}

function conat_setup_theme() {

	load_theme_textdomain( 'conat', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support('title-tag');
	add_theme_support('custom-header');
	add_theme_support('custom-background');
	add_theme_support('responsive-embeds');
	add_theme_support('wc-product-gallery-lightbox');
	add_theme_support('woocommerce');
	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'editor-styles' );
	
	//Set the default content width.
	$GLOBALS['content_width'] = 525;
	
	/*---------- Register image sizes ----------*/
	
	//Register image sizes
    add_image_size( 'conat_270x280', 270, 280, true ); //Speaker V1
    add_image_size( 'conat_480x350', 480, 350, true ); //Gallery V1
    add_image_size( 'conat_370x500', 370, 500, true ); //News V1 & Our Blog
    add_image_size( 'conat_315x410', 315, 410, true ); //Speakers V2
    add_image_size( 'conat_370x270', 370, 270, true ); //News V2
    add_image_size( 'conat_210x210', 210, 210, true ); //Thought Leadership V1
    add_image_size( 'conat_270x340', 270, 340, true ); //Speakers V3 & V4
    add_image_size( 'conat_120x120', 120, 120, true ); //Testimonials V1
    add_image_size( 'conat_370x250', 370, 250, true ); //News V3
    add_image_size( 'conat_80x80', 80, 80, true ); //Footer Recent News & Blog Sidebar
	
	/*---------- Register image sizes ends ----------*/

	// This theme uses wp_nav_menu() in two locations.
	register_nav_menus( array(
		'main_menu' => esc_html__( 'Main Menu', 'conat' ),
		'footer_menu' => esc_html__( 'Footer Menu', 'conat' ),
		'onepage_menu' => esc_html__( 'OnePage Menu', 'conat' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Add theme support for Custom Logo.
	add_theme_support( 'custom-logo', array(
		'width'      => 250,
		'height'     => 250,
		'flex-width' => true,
	) );

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, and column width.
 	 */
	add_editor_style();
	add_action( 'admin_init', 'conat_admin_init', 2000000 );
}

/**
 * [conat_admin_init]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */


function conat_admin_init() {
	remove_action( 'admin_notices', array( 'ReduxFramework', '_admin_notices' ), 99 );
}

/*---------- Sidebar settings ----------*/

/**
 * [conat_widgets_init]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */
function conat_widgets_init() {

	global $wp_registered_sidebars;

	$theme_options = get_theme_mod( 'conat' . '_options-mods' );

	register_sidebar( array(
		'name' => esc_html__( 'Default Sidebar', 'conat' ),
		'id' => 'default-sidebar',
		'description' => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'conat' ),
		'before_widget'=>'<div id="%1$s" class="widget sidebar-widget %2$s"><div class="widget-content %2$s">',
		'after_widget'=>'</div></div>',
		'before_title' => '<h4 class="sidebar-widget_title">',
		'after_title' => '</h4>'
	) );
	register_sidebar(array(
		'name' => esc_html__('Footer Widget', 'conat'),
		'id' => 'footer-sidebar',
		'description' => esc_html__('Widgets in this area will be shown in Footer Area.', 'conat'),
		'before_widget'=>'<div class="big-column col-lg-6 col-md-12 col-sm-12"><div id="%1$s" class="footer-column footer-widget %2$s">',
		'after_widget'=>'</div></div>',
		'before_title' => '<h4 class="footer-two_title">',
		'after_title' => '</h4>'
	));
	if ( class_exists( '\Elementor\Plugin' )){
		register_sidebar(array(
			'name' => esc_html__('Footer Widget Two', 'conat'),
			'id' => 'footer-sidebar-2',
			'description' => esc_html__('Widgets in this area will be shown in Footer Area.', 'conat'),
			'before_widget' => '<div class="col-lg-3 col-md-6 col-sm-12 footer-two_column"><div id="%1$s" class="footer-two-widget footer-widget %2$s">',
			'after_widget' => '</div></div>',
			'before_title' => '<h4 class="footer-two_title">',
			'after_title' => '</h4>'
		));
		register_sidebar(array(
			'name' => esc_html__('Footer Widget Three', 'conat'),
			'id' => 'footer-sidebar-3',
			'description' => esc_html__('Widgets in this area will be shown in Footer Area.', 'conat'),
			'before_widget' => '<div class="col-lg-4 col-md-6 col-sm-12 footer-three_column"><div id="%1$s" class="footer-widget footer-widget %2$s">',
			'after_widget' => '</div></div>',
			'before_title' => '<h4 class="footer-two_title">',
			'after_title' => '</h4>'
		));
		register_sidebar(array(
			'name' => esc_html__( 'Blog Widget', 'conat' ),
			'id' => 'blog-sidebar',
			'description' => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'conat' ),
			'before_widget'=>'<div id="%1$s" class="widget sidebar-widget blog-sidebar %2$s"><div class="widget-content %2$s">',
			'after_widget'=>'</div></div>',
			'before_title' => '<h4 class="sidebar-widget_title">',
			'after_title' => '</h4>'
		));
		register_sidebar(array(
			'name' => esc_html__('Products Widget', 'conat'),
			'id' => 'product-sidebar',
			'description' => esc_html__('Widgets in this area will be shown in products.', 'conat'),
			'before_widget'=>'<div id="%1$s" class="widget sidebar-widget product-widget %2$s"><div class="widget-content %2$s">',
			'after_widget'=>'</div></div>',
			'before_title' => '<h4 class="sidebar-widget_title">',
			'after_title' => '</h4>'
		));
	}
	
	if ( ! is_object( conat_WSH() ) ) {
		return;
	}

	$sidebars = conat_set( $theme_options, 'custom_sidebar_name' );

	foreach ( array_filter( (array) $sidebars ) as $sidebar ) {

		if ( conat_set( $sidebar, 'topcopy' ) ) {
			continue;
		}

		$name = $sidebar;
		if ( ! $name ) {
			continue;
		}
		$slug = str_replace( ' ', '_', $name );

		register_sidebar( array(
			'name'          => $name,
			'id'            => sanitize_title( $slug ),
			'before_widget' => '<div id="%1$s" class="%2$s widget ">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="widget-title"><h4>',
			'after_title'   => '</h4></div>',
		) );
	}

	update_option( 'wp_registered_sidebars', $wp_registered_sidebars );
}

add_action( 'widgets_init', 'conat_widgets_init' );

/*---------- Sidebar settings ends ----------*/

/*---------- Gutenberg settings ----------*/

function conat_gutenberg_editor_palette_styles() {
    add_theme_support( 'editor-color-palette', array(
        array(
            'name' => esc_html__( 'strong yellow', 'conat' ),
            'slug' => 'strong-yellow',
            'color' => '#f7bd00',
        ),
        array(
            'name' => esc_html__( 'strong white', 'conat' ),
            'slug' => 'strong-white',
            'color' => '#fff',
        ),
		array(
            'name' => esc_html__( 'light black', 'conat' ),
            'slug' => 'light-black',
            'color' => '#242424',
        ),
        array(
            'name' => esc_html__( 'very light gray', 'conat' ),
            'slug' => 'very-light-gray',
            'color' => '#797979',
        ),
        array(
            'name' => esc_html__( 'very dark black', 'conat' ),
            'slug' => 'very-dark-black',
            'color' => '#000000',
        ),
    ) );
	
	add_theme_support( 'editor-font-sizes', array(
		array(
			'name' => esc_html__( 'Small', 'conat' ),
			'size' => 10,
			'slug' => 'small'
		),
		array(
			'name' => esc_html__( 'Normal', 'conat' ),
			'size' => 15,
			'slug' => 'normal'
		),
		array(
			'name' => esc_html__( 'Large', 'conat' ),
			'size' => 24,
			'slug' => 'large'
		),
		array(
			'name' => esc_html__( 'Huge', 'conat' ),
			'size' => 36,
			'slug' => 'huge'
		)
	) );
	
}
add_action( 'after_setup_theme', 'conat_gutenberg_editor_palette_styles' );

/*---------- Gutenberg settings ends ----------*/

/*** Get Theme Version ***/
function conat_get_theme_version(){
	$theme = wp_get_theme();
	if( $theme->parent() ){
		return $theme->parent()->get('Version');
	}
	else{
		return $theme->get('Version');
	}
}

/*---------- Enqueue Styles and Scripts ----------*/

function conat_enqueue_scripts() {
	$theme_version = conat_get_theme_version();
	$options = conat_WSH()->option();
	
	$header_meta = get_post_meta( get_the_ID(), 'header_style_settings');
	$header_option = $options->get( 'header_style_settings' );
	$header = ( $header_meta ) ? $header_meta['0'] : $header_option;
	
	if( $options->get( 'primary_color' ) ){
		$primary_color = str_replace( '#', '' , $options->get( 'primary_color' ));
		$color_two = str_replace( '#', '' , $options->get( 'color_two' ));
		$color_three = str_replace( '#', '' , $options->get( 'color_three' ));
		$color_four = str_replace( '#', '' , $options->get( 'color_four' ));
		$color_five = str_replace( '#', '' , $options->get( 'color_five' ));
		$color_six = str_replace( '#', '' , $options->get( 'color_six' ));
		$color_seven = str_replace( '#', '' , $options->get( 'color_seven' ));
		$color_eight = str_replace( '#', '' , $options->get( 'color_eight' ));
		$color_nine = str_replace( '#', '' , $options->get( 'color_nine' ));
		$color_ten = str_replace( '#', '' , $options->get( 'color_ten' ));
		$color_eleven = str_replace( '#', '' , $options->get( 'color_eleven' ));
		$color_twelve = str_replace( '#', '' , $options->get( 'color_twelve' ));
	}
	else
	{
		$primary_color = str_replace( '#', '' , '#ffc300' );
		$color_two = str_replace( '#', '' , '#1a1719' );
		$color_three = str_replace( '#', '' , '#e00e7a' );
		$color_four = str_replace( '#', '' , '#2a00ff' );
		$color_five = str_replace( '#', '' , '#746a6f' );
		$color_six = str_replace( '#', '' , '#1967ea' );
		$color_seven = str_replace( '#', '' , '#f5f5f5' );
		$color_eight = str_replace( '#', '' , '#0e0058' );
		$color_nine = str_replace( '#', '' , '#150082' );
		$color_ten = str_replace( '#', '' , '#ebebeb' );
		$color_eleven = str_replace( '#', '' , '#000a43' );
		$color_twelve = str_replace( '#', '' , '#f8f8f8' );
	}
	
	$colors = '?primary_color='.$primary_color.'&color_two='.$color_two.'&color_three='.$color_three.'&color_four='.$color_four.'&color_five='.$color_five.'&color_six='.$color_six.'&color_seven='.$color_seven.'&color_eight='.$color_eight.'&color_nine='.$color_nine.'&color_ten='.$color_ten.'&color_eleven='.$color_eleven.'&color_twelve='.$color_twelve;
	
	//Styles
    wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.css', array(), $theme_version );
	wp_enqueue_style( 'fontawesome-all', get_template_directory_uri() . '/assets/css/fontawesome-all.css', array(), $theme_version );
	wp_enqueue_style( 'flaticon', get_template_directory_uri() . '/assets/css/flaticon_conat-flat.css', array(), $theme_version );
    wp_enqueue_style( 'animate', get_template_directory_uri() . '/assets/css/animate.css', array(), $theme_version );
	wp_enqueue_style( 'owl', get_template_directory_uri() . '/assets/css/owl.css', array(), $theme_version );
    wp_enqueue_style( 'jquery-ui', get_template_directory_uri() . '/assets/css/jquery-ui.css', array(), $theme_version );
    wp_enqueue_style( 'custom-animate', get_template_directory_uri() . '/assets/css/custom-animate.css', array(), $theme_version );
	wp_enqueue_style( 'magnific-popup', get_template_directory_uri() . '/assets/css/magnific-popup.css', array(), $theme_version );
	wp_enqueue_style( 'odometer-theme-default', get_template_directory_uri() . '/assets/css/odometer-theme-default.css', array(), $theme_version );
	wp_enqueue_style( 'bootstrap-touchspin', get_template_directory_uri() . '/assets/css/jquery.bootstrap-touchspin.css', array(), $theme_version );
	wp_enqueue_style( 'conat-main', get_stylesheet_uri() );
	wp_enqueue_style( 'conat-style', get_template_directory_uri() . '/assets/css/style.css', array(), $theme_version );
	wp_enqueue_style( 'conat-global', get_template_directory_uri() . '/assets/css/global.css', array(), $theme_version );
	wp_enqueue_style( 'conat-rtl', get_template_directory_uri() . '/assets/css/rtl.css', array(), $theme_version );
	wp_enqueue_style( 'conat-header', get_template_directory_uri() . '/assets/css/header.css', array(), $theme_version );
	wp_enqueue_style( 'conat-footer', get_template_directory_uri() . '/assets/css/footer.css', array(), $theme_version );
	wp_enqueue_style( 'conat-responsive', get_template_directory_uri() . '/assets/css/responsive.css', array(), $theme_version );
	wp_enqueue_style( 'conat-events', get_template_directory_uri() . '/assets/css/events.css', array(), $theme_version );
	wp_enqueue_style( 'conat-custom', get_template_directory_uri() . '/assets/css/custom.css', array(), $theme_version );
	wp_enqueue_style( 'conat-woocommerce', get_template_directory_uri() . '/assets/css/woocommerce.css', array(), $theme_version );
	wp_enqueue_style( 'conat-tut', get_template_directory_uri() . '/assets/css/tut.css', array(), $theme_version );
	wp_enqueue_style( 'conat-color-scheme', get_template_directory_uri() . '/assets/css/color.php'.$colors, $theme_version);
	
    //Scripts
	wp_enqueue_script( 'jquery-ui-core');
	wp_enqueue_script( 'popper', get_template_directory_uri().'/assets/js/popper.min.js', array( 'jquery' ), $theme_version, true );
    wp_enqueue_script( 'bootstrap', get_template_directory_uri().'/assets/js/bootstrap.min.js', array( 'jquery' ), $theme_version, true );
	wp_enqueue_script( 'appear', get_template_directory_uri().'/assets/js/appear.js', array( 'jquery' ), $theme_version, true );
	wp_enqueue_script( 'parallax', get_template_directory_uri().'/assets/js/parallax.min.js', array( 'jquery' ), $theme_version, true );
	wp_enqueue_script( 'tilt', get_template_directory_uri().'/assets/js/tilt.jquery.min.js', array( 'jquery' ), $theme_version, true );
	wp_enqueue_script( 'paroller', get_template_directory_uri().'/assets/js/jquery.paroller.min.js', array( 'jquery' ), $theme_version, true );
	wp_enqueue_script( 'owl', get_template_directory_uri().'/assets/js/owl.js', array( 'jquery' ), $theme_version, true );
	wp_enqueue_script( 'wow', get_template_directory_uri().'/assets/js/wow.js', array( 'jquery' ), $theme_version, true );
	wp_enqueue_script( 'element-in-view', get_template_directory_uri().'/assets/js/element-in-view.js', array( 'jquery' ), $theme_version, true );
	wp_enqueue_script( 'pagenav', get_template_directory_uri().'/assets/js/pagenav.js', array( 'jquery' ), $theme_version, true );
	wp_enqueue_script( 'backtotop', get_template_directory_uri().'/assets/js/backtotop.js', array( 'jquery' ), $theme_version, true );
	wp_enqueue_script( 'odometer', get_template_directory_uri().'/assets/js/odometer.js', array( 'jquery' ), $theme_version, true );
	wp_enqueue_script( 'parallax-scroll', get_template_directory_uri().'/assets/js/parallax-scroll.js', array( 'jquery' ), $theme_version, true );
    wp_enqueue_script( 'countdown', get_template_directory_uri().'/assets/js/jquery.countdown.js', array( 'jquery' ), $theme_version, true );
    wp_enqueue_script( 'magnific-popup', get_template_directory_uri().'/assets/js/magnific-popup.min.js', array( 'jquery' ), $theme_version, true );
    wp_enqueue_script( 'nav-tool', get_template_directory_uri().'/assets/js/nav-tool.js', array( 'jquery' ), $theme_version, true );
	wp_enqueue_script( 'jquery-ui', get_template_directory_uri().'/assets/js/jquery-ui.js', array( 'jquery' ), $theme_version, true );
	wp_enqueue_script( 'conat-main-script', get_template_directory_uri().'/assets/js/script.js', array(), false, true );
	if( is_singular() ) wp_enqueue_script('comment-reply');
}
add_action( 'wp_enqueue_scripts', 'conat_enqueue_scripts' );

/*---------- Enqueue styles and scripts ends ----------*/

/*---------- Google fonts ----------*/

function conat_fonts_url() {
	$fonts_url = '';
	$font_families['Manrope'] = 'Manrope:wght@300,400,500,600,700,800&display=swap';
	$font_families['Mrs_Saint_Delafield'] = 'Mrs Saint Delafield';
	$font_families = apply_filters( 'CONAT/includes/classes/header_enqueue/font_families', $font_families );

	$query_args = array(
		'family' => urlencode( implode( '|', $font_families ) ),
		'subset' => urlencode( 'latin,latin-ext' ),
	);

	$protocol  = is_ssl() ? 'https' : 'http';
	$fonts_url = add_query_arg( $query_args, $protocol . '://fonts.googleapis.com/css' );

	return esc_url_raw($fonts_url);
}

function conat_theme_styles() {
    wp_enqueue_style( 'conat-theme-fonts', conat_fonts_url(), array(), null );
}

add_action( 'wp_enqueue_scripts', 'conat_theme_styles' );
add_action( 'admin_enqueue_scripts', 'conat_theme_styles' );
/*---------- Google fonts ends ----------*/

/*---------- More functions ----------*/

// 1) conat_set function

/**
 * [conat_set description]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */
if ( ! function_exists( 'conat_set' ) ) {
	function conat_set( $var, $key, $def = '' ) {
		//if( ! $var ) return false;

		if ( is_object( $var ) && isset( $var->$key ) ) {
			return $var->$key;
		} elseif ( is_array( $var ) && isset( $var[ $key ] ) ) {
			return $var[ $key ];
		} elseif ( $def ) {
			return $def;
		} else {
			return false;
		}
	}
}

// 2) conat_add_editor_styles function
function conat_add_editor_styles() {
    add_editor_style( 'editor-style.css' );
}
add_action( 'admin_init', 'conat_add_editor_styles' );

// 3) Add specific CSS class by filter body class.
$options = conat_WSH()->option(); 
if( conat_set($options, 'boxed_wrapper') ){
	add_filter( 'body_class', function( $classes ) {
		$classes[] = 'boxed_wrapper';
		return $classes;
	} );
}

//Search Filter
function conat_custom_search( $query ) {
  if ( !is_admin() && $query->is_main_query() ) {
    if ( $query->is_search ) {
      $query->set( 'post_type', array( 'post', 'page', 'gallery', 'speaker', 'testimonials', 'faqs' ) );
    }
  }
}
add_action( 'pre_get_posts', 'conat_custom_search' );
/*---------- More functions ends ----------*/

//Warning Notification Disable
add_filter('doing_it_wrong_trigger_error', function () {return false;}, 10, 0);

/////////Shop/////////
//conat_related_products_limit function 
function conat_related_products_limit() {
  global $product;
	
	$args['posts_per_page'] = 6;
	return $args;
}
add_filter( 'woocommerce_output_related_products_args', 'conat_related_products_args', 20 );
  function conat_related_products_args( $args ) {
	$args['posts_per_page'] = 3; // 4 related products
	$args['columns'] = 1; // arranged in 2 columns
	return $args;
}

//Shop Product per page
function conat_shop_per_page( $cols ) {
  $cols = 12;
  return $cols;
}
add_filter( 'loop_shop_per_page', 'conat_shop_per_page', 20 );
/*---------- More functions ends ----------*/
