<?php
/**
 * 404 page file
 *
 * @package    WordPress
 * @subpackage Conat
 * @author     Theme Range <snankls@gmail.com>
 * @version    1.0
 */

$allowed_html = wp_kses_allowed_html( 'post' ); ?>

<?php get_header();
$data = \CONAT\Includes\Classes\Common::instance()->data( '404' )->get();
$options = conat_WSH()->option();
if ( class_exists( '\Elementor\Plugin' ) AND $data->get( 'tpl-type' ) == 'e' AND $data->get( 'tpl-elementor' ) ) {
	echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $data->get( 'tpl-elementor' ) );
} else { ?>

<!-- Page Title -->
<section class="page-title" <?php if ($data->get( 'banner' )){ ?>style="background-image: url(<?php echo esc_url( $data->get( 'banner' ) ); ?>)"<?php } ?>>
    <div class="auto-container">
        <div class="d-flex justify-content-between align-items-center flex-wrap">
            <div class="left-box">
                <div class="page-title_big"><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></div>
                <h2 class="page-title_heading"><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h2>
            </div>
            <ul class="bread-crumb clearfix">
                <?php echo conat_the_breadcrumb(); ?>
            </ul>
        </div>
    </div>
</section>
<!-- End Page Title -->

<!-- Error Section -->
<div class="error-section">
    <div class="auto-container">
        <div class="content">
            <h1><?php echo wp_kses( $options->get( 'error_404' ), $allowed_html ) ? wp_kses( $options->get( 'error_404' ), $allowed_html ) : esc_html_e( '404', 'conat' ); ?></h1>
            <h2><?php echo wp_kses( $options->get( 'error_text' ), $allowed_html ) ? wp_kses( $options->get( 'error_text' ), $allowed_html ) : esc_html_e( 'Oops... It looks like you ‘re lost !', 'conat' ); ?></h2>
            <div class="text"><?php echo wp_kses( $options->get( 'error_description' ), $allowed_html ) ? wp_kses( $options->get( 'error_description' ), $allowed_html ) : esc_html_e( 'Oops! The page you are looking for does not exist. It might have been moved or deleted.', 'conat' ); ?></div>
            <!-- Button Box -->
            <div class="button-box text-center">
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="theme-btn btn-style-one">
                    <span class="btn-wrap">
                        <span class="text-one"><?php echo wp_kses( $options->get('back_home_btn_label'), $allowed_html ) ? wp_kses( $options->get('back_home_btn_label'), $allowed_html ) : esc_html_e( 'Go To Home', 'conat' ); ?></span>
                        <span class="text-two"><?php echo wp_kses( $options->get('back_home_btn_label'), $allowed_html ) ? wp_kses( $options->get('back_home_btn_label'), $allowed_html ) : esc_html_e( 'Go To Home', 'conat' ); ?></span>
                    </span>
                </a>
            </div>
        </div>
    </div>
</div>
<!-- End Error Section -->

<?php
}
get_footer(); ?>
