<?php
return array(
	'title'      => 'Conat Tribe Event Setting',
	'id'         => 'conat_meta_tribe_event',
	'icon'       => 'el el-cogs',
	'position'   => 'normal',
	'priority'   => 'core',
	'post_types' => array( 'tribe_events' ),
	'sections'   => array(
		array(
			'id'     => 'conat_tribe_event_meta_setting',
			'fields' => array(
				array(
					'id'       => 'speaker_image',
					'type'     => 'media',
					'url'      => true,
					'title'    => esc_html__( 'Speaker Image', 'conat' ),
					'desc'     => esc_html__( 'Upload speaker image.', 'conat' ),
				),
				array(
					'id'    => 'speaker_name',
					'type'  => 'text',
					'title' => esc_html__( 'Speaker Name', 'conat' ),
				),
				array(
					'id'    => 'speaker_designation',
					'type'  => 'text',
					'title' => esc_html__( 'Speaker Designation', 'conat' ),
				),
				array(
					'id'    => 'short_description',
					'type'  => 'textarea',
					'title' => esc_html__( 'Short Description', 'conat' ),
				),
				
				/*Audio*/
				array(
					'id'    => 'audio',
					'type'  => 'select',
					'title' => esc_html__( 'Enable/Disable Audio', 'conat' ),
					'default' => 'none',
					'options'  => array(
						'none' => esc_html__( 'None', 'conat' ),
						'sc_audio' => esc_html__( 'Sound Cloud', 'conat' ),
					),
				),
				array(
					'id'    => 'sc_id',
					'type'  => 'text',
					'title' => esc_html__( 'Sound Cloud ID', 'conat' ),
					'placeholder' => '1474409941',
					'required' => array('audio', 'equals', 'sc_audio'),
				),
				array(
					'id' => 'auto_play',
					'type' => 'switch',
					'title' => esc_html__('Disable Auto Play', 'conat'),
					'default' => true,
					'required' => array('audio', 'equals', 'sc_audio'),
				),
			),
		),
	),
);