<?php
return array(
	'id'     => 'conat_banner_settings',
	'title'  => esc_html__( "Conat Banner Settings", "conat" ),
	'fields' => array(
		array(
			'id'      => 'banner_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Banner Source Type', 'conat' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'conat' ),
				'e' => esc_html__( 'Elementor', 'conat' ),
			),
			'default' => '',
		),
		array(
			'id'       => 'banner_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'conat' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
				'posts_per_page'=> -1,
			],
			'required' => [ 'banner_source_type', '=', 'e' ],
		),
		array(
			'id'       => 'banner_page_banner',
			'type'     => 'switch',
			'title'    => esc_html__( 'Show Banner', 'conat' ),
			'default'  => false,
			'required' => [ 'banner_source_type', '=', 'd' ],
		),
		array(
			'id'       => 'banner_banner_title',
			'type'     => 'text',
			'title'    => esc_html__( 'Banner Section Title', 'conat' ),
			'desc'     => esc_html__( 'Enter the title to show in banner section', 'conat' ),
			'required' => array( 'banner_page_banner', '=', true ),
		),
		array(
			'id'       => 'banner_page_background',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Background Image', 'conat' ),
			'desc'     => esc_html__( 'Upload background image for banner', 'conat' ),
			'required' => array( 'banner_page_banner', '=', true ),
		),
	),
);