<?php
///----Blog widgets---
//Popular Post
class Conat_Popular_Post extends WP_Widget
{
	function __construct()
	{
		parent::__construct( 'Conat_Popular_Post', esc_html__('Conat Popular Post','conat'), array( 'description' => esc_html__('Show the Popular post for blog.', 'conat' )) );
	}
	
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		echo wp_kses_post($before_widget); ?>
		
        <div class="post-widget">
			<?php echo wp_kses_post($before_title.$title.$after_title); ?>
        
            <?php $query_string = 'posts_per_page='.$instance['number'];
            if( $instance['cat'] ) $query_string .= '&cat='.$instance['cat'];
            $this->posts($query_string); ?>
        </div>
        
		<?php echo wp_kses_post($after_widget);
	}
	
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		return $instance;
	}
	
	function form($instance)
	{
		$title = $instance ? $instance['title'] : __('Recent Post', 'conat');
		$number = $instance ? $instance['number'] : 3;
		$cat = $instance ? $instance['cat'] : '';
		?>
			
        <p>
            <label><?php esc_html_e('Title: ', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('title')); ?>" class="widefat" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label><?php esc_html_e('No. of Posts:', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('number')); ?>" class="widefat" value="<?php echo esc_attr( $number ); ?>" />
        </p>
    	<p>
            <label><?php esc_html_e('Category', 'conat'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'conat'), 'selected'=>$cat, 'class'=>'widefat', 'name'=>$this->get_field_name('categories')) ); ?>
        </p>
            
		<?php 
	}
	
	function posts($query_string)
	{
		$query = new WP_Query($query_string);
		if( $query->have_posts() ):?>
        
			<?php global $post;
			while( $query->have_posts() ): $query->the_post(); ?>
           	<!-- Post -->
            <div class="post">
                <div class="thumb"><a href="<?php echo esc_url(get_the_permalink(get_the_id())); ?>"><?php the_post_thumbnail('conat_80x80'); ?></a></div>
                <div class="post-date"><?php echo get_the_date(); ?></div>
                <h6><a href="<?php echo esc_url(get_the_permalink(get_the_id())); ?>"><?php the_title(); ?></a></h6>
            </div>
            <?php endwhile; ?>
            
        <?php endif;
		wp_reset_postdata();
    }
}

//Download Our Brochures
class Conat_Download_Brochures extends WP_Widget
{
	function __construct()
	{
		parent::__construct( 'Conat_Download_Brochures', esc_html__('Conat Download Brochures', 'conat'), array( 'description' => esc_html__('Show the Download Our Brochures in Services Sidebar.', 'conat' )) );
	}
	
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		echo wp_kses_post($before_widget); ?>
      		
		<!-- Broucher Widget -->
		<div class="broucher-widget">
			<div class="widget-content" style="background-image: url(<?php echo esc_url(get_template_directory_uri().'/assets/images/background/pattern-10.png'); ?>)">
				<h3><?php echo wp_kses_post($instance['title']); ?></h3>
				<div class="text"><?php echo wp_kses_post($instance['content']); ?></div>
				
				<?php if($instance['button_link'] and $instance['button_name']) { ?>
				<a href="<?php echo esc_url($instance['button_link']); ?>" class="download"><?php echo wp_kses_post($instance['button_name']); ?></a>
				<?php } ?>
			</div>
		</div>

        <?php
		echo wp_kses_post($after_widget);
	}
	
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['content'] = $new_instance['content'];
		$instance['button_name'] = $new_instance['button_name'];
		$instance['button_link'] = $new_instance['button_link'];
		return $instance;
	}
	
	function form($instance)
	{
		$title = $instance ? $instance['title'] : '';
		$content = $instance ? $instance['content'] : '';
		$button_name = $instance ? $instance['button_name'] : '';
		$button_link = $instance ? $instance['button_link'] : '';
		?>
        
        <p>
            <label><?php esc_html_e('Enter Title:', 'conat'); ?></label>
			<input type="text" name="<?php echo esc_attr($this->get_field_name('title')); ?>" class="widefat" value="<?php echo esc_attr($title); ?>" />
        </p>
		<p>
            <label><?php esc_html_e('Content:', 'conat'); ?></label>
            <textarea class="widefat" name="<?php echo esc_attr($this->get_field_name('content')); ?>" ><?php echo wp_kses_post($content); ?></textarea>
        </p>
        <p>
            <label><?php esc_html_e('Button Title:', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('button_name')); ?>" class="widefat" value="<?php echo esc_attr($button_name); ?>" />
        </p>
        <p>
            <label><?php esc_html_e('Button Link:', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('button_link')); ?>" class="widefat" value="<?php echo esc_attr($button_link); ?>" />
        </p>
               
		<?php 
	}
}

///---Footer Widgets V1---
//About Company V1
class Conat_About_Company_V1 extends WP_Widget
{
	function __construct()
	{
		parent::__construct( 'Conat_About_Company_V1', esc_html__('Conat About Company V1','conat'), array( 'description' => esc_html__('Show the About Company in footer v1', 'conat' )) );
	}
	
	function widget($args, $instance) {
		extract( $args );
		echo wp_kses_post($before_widget);
	?>
    
	<div class="d-flex justify-content-between align-items-center flex-wrap">
        <div class="logo"><a href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_url($instance['logo_image']); ?>" alt="<?php esc_attr_e('Logo', 'conat'); ?>"></a></div>
        
        <?php if( $instance['show'] ): ?>
        <!-- Social Box -->
        <div class="footer-social_list">
        	<?php echo wp_kses_post(conat_get_social_icons2()); ?>
        </div>
        <?php endif; ?>
    </div>
    <div class="footer-text footer-three_text"><?php echo wp_kses_post($instance['content']); ?></div>
    
	<?php
		echo wp_kses_post($after_widget);
	}
	
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['logo_image'] = strip_tags($new_instance['logo_image']);
		$instance['content'] = $new_instance['content'];
		$instance['show'] = $new_instance['show'];
		return $instance;
	}
	
	function form($instance)
	{
		$logo_image = $instance ? $instance['logo_image'] : get_template_directory_uri(). '/assets/images/logo.png';
		$content = $instance ? $instance['content'] : '';
		$show = $instance ? $instance['show'] : '';
		?>

		<p>
            <label><?php esc_html_e('Logo Image URL:', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('logo_image')); ?>" placeholder="<?php esc_attr_e('Image URL', 'conat');?>" class="widefat" value="<?php echo esc_attr($logo_image); ?>" />
        </p>
        <p>
            <label><?php esc_html_e('Content:', 'conat'); ?></label>
            <textarea class="widefat" name="<?php echo esc_attr($this->get_field_name('content')); ?>"><?php echo wp_kses_post($content); ?></textarea>
        </p>
		<p>
            <label><?php esc_html_e('Show Social Icons:', 'conat'); ?></label>
			<?php $selected = ( $show ) ? ' checked="checked"' : ''; ?>
            <input type="checkbox" class="widefat" name="<?php echo esc_attr($this->get_field_name('show')); ?>" value="true" <?php echo esc_attr($selected); ?> />
        </p>
        
        <style>
        textarea,
        select {
			float:none;
			display: block;
			width: 100%;
		}
		</style>

		<?php
	}
}

//Contact Info V1
class Conat_Contact_Info_V1 extends WP_Widget
{
	function __construct()
	{
		parent::__construct( 'Conat_Contact_Info_V1', esc_html__('Conat Contact Info V1','conat'), array( 'description' => esc_html__('Show the contact info in footer v1.', 'conat' )) );
	}

	function widget($args, $instance)
	{
		extract( $args );
		echo wp_kses_post($before_widget); ?>
      	
        <div class="row clearfix">
        	<?php if($instance['address_title'] OR $instance['address']) { ?>
            <div class="footer-info-column col-lg-4 col-md-4 col-sm-12">
                <span class="footer-info-icon flaticon-placeholder-1"></span>
                <h6 class="footer-info_title"><?php echo wp_kses_post($instance['address_title']); ?></h6>
                <div class="footer-info_text"><?php echo wp_kses_post($instance['address']); ?></div>
            </div>
            <?php } ?>
            
        	<?php if($instance['contact_title'] OR $instance['email_address'] OR $instance['phone_number']) { ?>
            <div class="footer-info-column col-lg-4 col-md-4 col-sm-12">
                <span class="footer-info-icon flaticon-message"></span>
                <h6 class="footer-info_title"><?php echo wp_kses_post($instance['contact_title']); ?></h6>
                <div class="footer-info_text"><?php echo sanitize_email($instance['email_address']); ?> <br> <?php echo wp_kses_post($instance['phone_number']); ?></div>
            </div>
            <?php } ?>
            
        	<?php if($instance['working_hours_title'] OR $instance['working_hours']) { ?>
            <div class="footer-info-column col-lg-4 col-md-4 col-sm-12">
                <span class="footer-info-icon flaticon-clock"></span>
                <h6 class="footer-info_title"><?php echo wp_kses_post($instance['working_hours_title']); ?></h6>
                <div class="footer-info_text"><?php echo wp_kses_post($instance['working_hours']); ?></div>
            </div>
            <?php } ?>
        </div>
        
        <?php
		
		echo wp_kses_post($after_widget);
	}
	
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['address_title'] = strip_tags($new_instance['address_title']);
		$instance['address'] = $new_instance['address'];
		
		$instance['contact_title'] = strip_tags($new_instance['contact_title']);
		$instance['email_address'] = $new_instance['email_address'];
		$instance['phone_number'] = $new_instance['phone_number'];
		
		$instance['working_hours_title'] = strip_tags($new_instance['working_hours_title']);
		$instance['working_hours'] = $new_instance['working_hours'];
		return $instance;
	}
	
	function form($instance)
	{
		$address_title = $instance ? $instance['address_title'] : __('ADDRESS', 'conat');
		$address = $instance ? $instance['address'] : '';
		
		$contact_title = $instance ? $instance['contact_title'] : __('MAIL TO US', 'conat');
		$email_address = $instance ? $instance['email_address'] : '';
		$phone_number = $instance ? $instance['phone_number'] : '';
		
		$working_hours_title = $instance ? $instance['working_hours_title'] : __('TIMEING', 'conat');
		$working_hours = $instance ? $instance['working_hours'] : '';
		?>
        
        <p>
            <label><?php esc_html_e('Address Title:', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('address_title')); ?>" class="widefat" value="<?php echo esc_attr($address_title); ?>" />
        </p>
        <p>
            <label><?php esc_html_e('Address:', 'conat'); ?></label>
            <textarea name="<?php echo esc_attr($this->get_field_name('address')); ?>" class="widefat"><?php echo wp_kses_post($address); ?></textarea>
        </p>
        
        <p>
            <label><?php esc_html_e('Contact Title:', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('contact_title')); ?>" class="widefat" value="<?php echo esc_attr($contact_title); ?>" />
        </p>
        <p>
            <label><?php esc_html_e('Email Address: ', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('email_address')); ?>" class="widefat" value="<?php echo esc_attr( $email_address ); ?>" />
        </p>
        <p>
            <label><?php esc_html_e('Phone Number: ', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('phone_number')); ?>" class="widefat" value="<?php echo esc_attr( $phone_number ); ?>" />
        </p>
        
        <p>
            <label><?php esc_html_e('Working Hours Title:', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('working_hours_title')); ?>" class="widefat" value="<?php echo esc_attr($working_hours_title); ?>" />
        </p>
        <p>
            <label><?php esc_html_e('Working Hours:', 'conat'); ?></label>
            <textarea name="<?php echo esc_attr($this->get_field_name('working_hours')); ?>" class="widefat"><?php echo wp_kses_post($working_hours); ?></textarea>
        </p>
        
        <style>
        textarea,
        select {
			float:none;
			display: block;
			width: 100%;
		}
		</style>
        
		<?php 
	}
}

///---Footer Widgets V2---
//About Company V2
class Conat_About_Company_V2 extends WP_Widget
{
	function __construct()
	{
		parent::__construct( 'Conat_About_Company_V2', esc_html__('Conat About Company V2','conat'), array( 'description' => esc_html__('Show the About Company in footer v2', 'conat' )) );
	}
	
	function widget($args, $instance) {
		extract( $args );
		echo wp_kses_post($before_widget);
	?>
    
    <div class="footer-two-widget logo-widget">
        <div class="footer-two_logo">
            <a href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_url($instance['logo_image']); ?>" alt="<?php esc_attr_e('Logo', 'conat'); ?>"></a>
        </div>
        <div class="footer-two_text"><?php echo wp_kses_post($instance['content']); ?></div>
    </div>
    
	<?php
		echo wp_kses_post($after_widget);
	}
	
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['logo_image'] = strip_tags($new_instance['logo_image']);
		$instance['content'] = $new_instance['content'];
		return $instance;
	}
	
	function form($instance)
	{
		$logo_image = $instance ? $instance['logo_image'] : get_template_directory_uri(). '/assets/images/logo.png';
		$content = $instance ? $instance['content'] : '';
		?>

		<p>
            <label><?php esc_html_e('Logo Image URL:', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('logo_image')); ?>" placeholder="<?php esc_attr_e('Image URL', 'conat');?>" class="widefat" value="<?php echo esc_attr($logo_image); ?>" />
        </p>
        <p>
            <label><?php esc_html_e('Content:', 'conat'); ?></label>
            <textarea class="widefat" name="<?php echo esc_attr($this->get_field_name('content')); ?>"><?php echo wp_kses_post($content); ?></textarea>
        </p>
        
        <style>
        textarea,
        select {
			float:none;
			display: block;
			width: 100%;
		}
		</style>

		<?php
	}
}

//Contact Info V2
class Conat_Contact_Info_V2 extends WP_Widget
{
	function __construct()
	{
		parent::__construct( 'Conat_Contact_Info_V2', esc_html__('Conat Contact Info V2','conat'), array( 'description' => esc_html__('Show the contact info in footer v2.', 'conat' )) );
	}

	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		echo wp_kses_post($before_widget); ?>
      	
        <div class="news-widget">
            <?php echo wp_kses_post($before_title.$title.$after_title); ?>
            
            <ul class="footer-two_contact-list">
                <?php if ($instance['phone_number']){ ?><li><span class="icon fa-solid fa-phone fa-fw"></span><?php echo wp_kses_post($instance['phone_number']); ?></li><?php } ?>
                <?php if ($instance['email_address']){ ?><li><span class="icon fa-solid fa-envelope fa-fw"></span> <a href="mailto:<?php echo wp_kses_post($instance['email_address']); ?>"><?php echo sanitize_email($instance['email_address']); ?></a></li><?php } ?>
                <?php if ($instance['address']){ ?><li><span class="icon fa-solid fa-map-marker fa-fw"></span><?php echo wp_kses_post($instance['address']); ?></li><?php } ?>
            </ul>
            
            <?php if( $instance['show'] ): ?>
            <!-- Social Box -->
            <ul class="footer-two_socials">
                <?php echo wp_kses_post(conat_get_social_icons3()); ?>
            </ul>
            <?php endif; ?>
        </div>
        
        <?php
		
		echo wp_kses_post($after_widget);
	}
	
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['phone_number'] = $new_instance['phone_number'];
		$instance['email_address'] = $new_instance['email_address'];
		$instance['address'] = $new_instance['address'];
		$instance['show'] = $new_instance['show'];

		return $instance;
	}
	
	function form($instance)
	{
		$title = $instance ? $instance['title'] : __('Information', 'conat');
		$phone_number = $instance ? $instance['phone_number'] : '';
		$email_address = $instance ? $instance['email_address'] : '';
		$address = $instance ? $instance['address'] : '';
		$show = $instance ? $instance['show'] : '';
		
		?>
        
        <p>
            <label><?php esc_html_e('Title:', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('title')); ?>" class="widefat" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label><?php esc_html_e('Phone Number: ', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('phone_number')); ?>" class="widefat" value="<?php echo esc_attr( $phone_number ); ?>" />
        </p>
        <p>
            <label><?php esc_html_e('Email Address: ', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('email_address')); ?>" class="widefat" value="<?php echo esc_attr( $email_address ); ?>" />
        </p>
        <p>
            <label><?php esc_html_e('Address:', 'conat'); ?></label>
            <textarea name="<?php echo esc_attr($this->get_field_name('address')); ?>" class="widefat"><?php echo wp_kses_post($address); ?></textarea>
        </p>
		<p>
            <label><?php esc_html_e('Show Social Icons:', 'conat'); ?></label>
			<?php $selected = ( $show ) ? ' checked="checked"' : ''; ?>
            <input type="checkbox" class="widefat" name="<?php echo esc_attr($this->get_field_name('show')); ?>" value="true" <?php echo esc_attr($selected); ?> />
        </p>
        
        <style>
        textarea,
        select {
			float:none;
			display: block;
			width: 100%;
		}
		</style>
        
		<?php 
	}
}

//Recent Post
class Conat_Recent_Post extends WP_Widget
{
	function __construct()
	{
		parent::__construct( 'Conat_Recent_Post', esc_html__('Conat Recent Post', 'conat'), array( 'description' => esc_html__('Show the Recent Post in footer v2', 'conat' )) );
	}

	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		echo wp_kses_post($before_widget); ?>
        
        <div class="news-widget">
            <?php echo wp_kses_post($before_title.$title.$after_title); ?>
            
			<?php $query_string = 'posts_per_page='.$instance['number'];
			if( $instance['cat'] ) $query_string .= '&cat='.$instance['cat'];
			$this->posts($query_string); ?>
        </div>
        
		<?php echo wp_kses_post($after_widget);
	}
	
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		return $instance;
	}
	
	function form($instance)
	{
		$title = $instance ? $instance['title'] : __('Recent Post', 'conat');
		$number = $instance ? $instance['number'] : 2;
		$cat = $instance ? $instance['cat'] : '';
		?>
		
        <p>
            <label><?php esc_html_e('Title:', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('title')); ?>" class="widefat" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label><?php esc_html_e('No. of Posts:', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('number')); ?>" class="widefat" value="<?php echo esc_attr( $number ); ?>" />
        </p>
    	<p>
            <label><?php esc_html_e('Category', 'conat'); ?></label>
            <?php
				wp_dropdown_categories(
					array(
						'show_option_all' => esc_html__('All Categories', 'conat'),
						'selected' => $cat,
						'class' => 'widefat',
						'name' => $this->get_field_name('categories'),
					)
				);
			?>
        </p>
            
		<?php 
	}
	
	function posts($query_string)
	{
		$query = new WP_Query($query_string);
		if( $query->have_posts() ):?>
        	
			<?php global $post;
			while( $query->have_posts() ): $query->the_post(); ?>
            <!--News Widget Block-->
            <div class="news-widget-block">
                <div class="news-widget_image">
                    <a href="<?php echo esc_url(get_the_permalink(get_the_id())); ?>"><?php the_post_thumbnail('conat_80x80'); ?></a>
                </div>
                <div class="news-widget_post-date"><?php echo get_the_date(); ?></div>
                <h6 class="news-widget_title"><a href="<?php echo esc_url(get_the_permalink(get_the_id())); ?>"><?php echo wp_trim_words( get_the_title(), 6, '...' ); ?></a></h6>
            </div>
            <?php endwhile; ?>
            
        <?php endif;
		wp_reset_postdata();
    }
}

///---Footer Widgets V3---
//Contact Info V3
class Conat_Contact_Info_V3 extends WP_Widget
{
	function __construct()
	{
		parent::__construct( 'Conat_Contact_Info_V3', esc_html__('Conat Contact Info V3','conat'), array( 'description' => esc_html__('Show the contact info in footer v3.', 'conat' )) );
	}

	function widget($args, $instance)
	{
		extract( $args );
		echo wp_kses_post($before_widget); ?>
        
        <ul class="footer-three_contact-list">
        	<?php if($instance['address_title'] OR $instance['address']) { ?>
            <li>
                <span class="icon flaticon-map"></span>
                <strong><?php echo wp_kses_post($instance['address_title']); ?></strong>
                <?php echo wp_kses_post($instance['address']); ?>
            </li>
            <?php } ?>
            
        	<?php if($instance['email_title'] OR $instance['email_address']) { ?>
            <li>
                <span class="icon flaticon-email-1"></span>
                <strong><?php echo wp_kses_post($instance['email_title']); ?></strong>
                <?php echo sanitize_email($instance['email_address']); ?>
            </li>
            <?php } ?>
            
        	<?php if($instance['working_hours_title'] OR $instance['working_hour']) { ?>
            <li>
                <span class="icon flaticon-clock"></span>
                <strong><?php echo wp_kses_post($instance['working_hours_title']); ?></strong>
                <?php echo wp_kses_post($instance['working_hours']); ?>
            </li>
            <?php } ?>
        </ul>
            
		<?php if( $instance['show'] ): ?>
        <!-- Social Box -->
        <div class="footer-social_list">
            <?php echo wp_kses_post(conat_get_social_icons2()); ?>
        </div>
        <?php endif; ?>
        
        <?php
		
		echo wp_kses_post($after_widget);
	}
	
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['address_title'] = strip_tags($new_instance['address_title']);
		$instance['address'] = $new_instance['address'];
		$instance['email_title'] = strip_tags($new_instance['email_title']);
		$instance['email_address'] = $new_instance['email_address'];
		$instance['working_hours_title'] = strip_tags($new_instance['working_hours_title']);
		$instance['working_hours'] = $new_instance['working_hours'];
		$instance['show'] = $new_instance['show'];
		
		return $instance;
	}
	
	function form($instance)
	{
		$address_title = $instance ? $instance['address_title'] : __('ADDRESS', 'conat');
		$address = $instance ? $instance['address'] : '';
		$email_title = $instance ? $instance['email_title'] : __('MAIL TO US', 'conat');
		$email_address = $instance ? $instance['email_address'] : '';
		$working_hours_title = $instance ? $instance['working_hours_title'] : __('TIMEING', 'conat');
		$working_hours = $instance ? $instance['working_hours'] : '';
		$show = $instance ? $instance['show'] : '';
		?>
        
        <p>
            <label><?php esc_html_e('Address Title:', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('address_title')); ?>" class="widefat" value="<?php echo esc_attr($address_title); ?>" />
        </p>
        <p>
            <label><?php esc_html_e('Address:', 'conat'); ?></label>
            <textarea name="<?php echo esc_attr($this->get_field_name('address')); ?>" class="widefat"><?php echo wp_kses_post($address); ?></textarea>
        </p>
        
        <p>
            <label><?php esc_html_e('Email Title:', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('email_title')); ?>" class="widefat" value="<?php echo esc_attr($email_title); ?>" />
        </p>
        <p>
            <label><?php esc_html_e('Email Address: ', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('email_address')); ?>" class="widefat" value="<?php echo esc_attr( $email_address ); ?>" />
        </p>
        <p>
            <label><?php esc_html_e('Working Hours Title:', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('working_hours_title')); ?>" class="widefat" value="<?php echo esc_attr($working_hours_title); ?>" />
        </p>
        <p>
            <label><?php esc_html_e('Working Hours:', 'conat'); ?></label>
            <textarea name="<?php echo esc_attr($this->get_field_name('working_hours')); ?>" class="widefat"><?php echo wp_kses_post($working_hours); ?></textarea>
        </p>
		<p>
            <label><?php esc_html_e('Show Social Icons:', 'conat'); ?></label>
			<?php $selected = ( $show ) ? ' checked="checked"' : ''; ?>
            <input type="checkbox" class="widefat" name="<?php echo esc_attr($this->get_field_name('show')); ?>" value="true" <?php echo esc_attr($selected); ?> />
        </p>
        
        <style>
        textarea,
        select {
			float:none;
			display: block;
			width: 100%;
		}
		</style>
        
		<?php 
	}
}

//Subscribe
class Conat_Subscriber extends WP_Widget
{
	function __construct()
	{
		parent::__construct( 'Conat_Subscriber', esc_html__('Conat Subscriber', 'conat'), array( 'description' => esc_html__('Show the subscriber in footer v3', 'conat' )) );
	}
	
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		echo wp_kses_post($before_widget);
		?>
      		
            <div class="newsletter-widget">
                <div class="footer-newsletter_title"><?php echo wp_kses_post($instance['subtitle']); ?></div>
                <h4 class="footer-newsletter_heading"><?php echo wp_kses_post($instance['title']); ?></h4>
                
                <?php if ($instance['contact_form']){ ?>
                <!-- Subscribe Box -->
                <div class="subscribe-box style-three">
                    <?php echo do_shortcode('[contact-form-7 id="'.esc_attr($instance['contact_form']).'"]'); ?>
                </div>
                <?php } ?>
            </div>
            
		<?php
		
		echo wp_kses_post($after_widget);
	}
	
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['subtitle'] = strip_tags($new_instance['subtitle']);
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['contact_form'] = $new_instance['contact_form'];
		return $instance;
	}
	
	function form($instance)
	{
		$subtitle = $instance ? $instance['subtitle'] : __('Get The Latest Updates', 'conat');
		$title = $instance ? $instance['title'] : __('Signup For Newsletter', 'conat');
		$contact_form = $instance ? $instance['contact_form'] : '';
		?>
        
        <p>
            <label><?php esc_html_e('Sub Title:', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('subtitle')); ?>" class="widefat" value="<?php echo esc_attr($subtitle); ?>" />
        </p>
        <p>
            <label><?php esc_html_e('Title:', 'conat'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('title')); ?>" class="widefat" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label><?php esc_html_e('Select Subscribe Form:', 'conat'); ?></label>
            <select name="<?php echo esc_attr($this->get_field_name('contact_form')); ?>" class="widefat">
            	<?php $cf7 = get_posts( 'post_type="wpcf7_contact_form"&numberposts=-1' );
				foreach($cf7 as $cform) { ?>
            	<option value="<?php echo $cform->ID; ?>" <?php selected($contact_form, $cform->ID); ?>><?php echo $cform->post_title; ?></option>
                <?php } ?>
            </select>
        </p>
        
        <style>
        textarea,
        select {
			float:none;
			display: block;
			width: 100%;
		}
		</style>
        
		<?php 
	}
	
}
