<?php add_action( 'init', 'conat_add_tax' );
function conat_add_tax() {
	
	$options = conat_WSH()->option();
	$allowed_html = wp_kses_allowed_html( 'post' );
		
	//Speaker Taxonomy Start
	$speaker_name = $options->get('speaker_name');
	$speaker_cat_name = isset($speaker_name) ? $speaker_name.__(' Category', 'conat') : __('Testimonial Category', 'conat');
	$labels = array(
		'name'              => $speaker_cat_name,
		'singular_name'     => $speaker_cat_name,
		'menu_name'         => $speaker_cat_name,
		'search_items'      => __( 'Search Category', 'conat' ),
		'all_items'         => __( 'All Categories', 'conat' ),
		'parent_item'       => __( 'Parent Category', 'conat' ),
		'parent_item_colon' => __( 'Parent Category:', 'conat' ),
		'edit_item'         => __( 'Edit Category', 'conat' ),
		'update_item'       => __( 'Update Category', 'conat' ),
		'add_new_item'      => __( 'Add New Category', 'conat' ),
		'new_item_name'     => __( 'New Category Name', 'conat' ),
	);
	$args   = array(
		'hierarchical'       => true,
		'labels'             => $labels,
		'show_ui'            => true,
		'show_admin_column'  => true,
		'query_var'          => true,
		'public'             => true,
		'publicly_queryable' => true,
		'rewrite'            => array( 'slug' => 'speaker_cat' ),
	);
	register_taxonomy( 'speaker_cat', 'speaker', $args );
	
	
	//Testimonials Taxonomy
	$testimonial_name = $options->get('testimonial_name');
	$testimonial_cat_name = isset($testimonial_name) ? $testimonial_name.__(' Category', 'conat') : __('Testimonial Category', 'conat');
	$labels = array(
		'name'              => $testimonial_cat_name,
		'singular_name'     => $testimonial_cat_name,
		'menu_name'         => $testimonial_cat_name,
		'search_items'      => __( 'Search Category', 'conat' ),
		'all_items'         => __( 'All Categories', 'conat' ),
		'parent_item'       => __( 'Parent Category', 'conat' ),
		'parent_item_colon' => __( 'Parent Category:', 'conat' ),
		'edit_item'         => __( 'Edit Category', 'conat' ),
		'update_item'       => __( 'Update Category', 'conat' ),
		'add_new_item'      => __( 'Add New Category', 'conat' ),
		'new_item_name'     => __( 'New Category Name', 'conat' ),
	);
	$args = array(
		'hierarchical'       => true,
		'labels'             => $labels,
		'show_ui'            => true,
		'show_admin_column'  => true,
		'query_var'          => true,
		'public'             => true,
		'publicly_queryable' => true,
		'rewrite'            => array( 'slug' => 'testimonials_cat' ),
	);
	register_taxonomy( 'testimonials_cat', 'testimonials', $args );
	
	
	//FAQs Taxonomy
	$faqs_name = $options->get('faqs_name');
	$faqs_cat_name = isset($faqs_name) ? $faqs_name.__(' Category', 'conat') : __('FAQs Category', 'conat');
	$labels = array(
		'name'              => $faqs_cat_name,
		'singular_name'     => $faqs_cat_name,
		'menu_name'         => $faqs_cat_name,
		'search_items'      => __( 'Search Category', 'conat' ),
		'all_items'         => __( 'All Categories', 'conat' ),
		'parent_item'       => __( 'Parent Category', 'conat' ),
		'parent_item_colon' => __( 'Parent Category:', 'conat' ),
		'edit_item'         => __( 'Edit Category', 'conat' ),
		'update_item'       => __( 'Update Category', 'conat' ),
		'add_new_item'      => __( 'Add New Category', 'conat' ),
		'new_item_name'     => __( 'New Category Name', 'conat' ),
	);
	$args = array(
		'hierarchical'       => true,
		'labels'             => $labels,
		'show_ui'            => true,
		'show_admin_column'  => true,
		'query_var'          => true,
		'public'             => true,
		'publicly_queryable' => true,
		'rewrite'            => array( 'slug' => 'faqs_cat' ),
	);
	register_taxonomy( 'faqs_cat', 'faqs', $args );
}
