<?php
add_action( 'init', 'conat_add_posttype' );
function conat_add_posttype() {
	$options = conat_WSH()->option();
	$allowed_html = wp_kses_allowed_html( 'post' );
	
	//Speakers
	$spaker_name = $options->get('speaker_name');
	$args = array( 
		'label' => isset($spaker_name) ? $spaker_name : esc_html__('Speakers', 'conat'),
		'public' => true,
		'publicly_queryable' => true,
		'menu_icon' => 'dashicons-admin-users',
		'status' => true,
		'show_ui' => true,
		'menu_position' => 35,
		'supports' => array( 
			'title',
			'editor',
			'thumbnail',
		),
		'rewrite' => array(
			'slug' => 'speakers'
		),
	);
	register_post_type('speaker', $args);
	
	//Testimonials
	$testimonial_name = $options->get('testimonial_name');
	$args = array( 
		'label' => isset($testimonial_name) ? $testimonial_name : esc_html__('Testimonials', 'conat'),
		'public' => true,
		'publicly_queryable' => true,
		'menu_icon' => 'dashicons-testimonial',
		'status' => true,
		'show_ui' => true,
		'menu_position' => 35,
		'supports' => array( 
			'title',
			'editor',
			'thumbnail',
		),
		'rewrite' => array(
			'slug' => 'testimonials'
		),
	);
	register_post_type('testimonials', $args);
	
	//FAQs
	$faqs_name = $options->get('faqs_name');
	$args = array( 
		'label' => isset($faqs_name) ? $faqs_name : esc_html__('FAQs', 'conat'),
		'public' => true,
		'publicly_queryable' => true,
		'menu_icon' => 'dashicons-edit-page',
		'status' => true,
		'show_ui' => true,
		'menu_position' => 36,
		'supports' => array( 
			'title',
			'editor',
		),
		'rewrite' => array(
			'slug' => 'faqs'
		),
	);
	register_post_type('faqs', $args);
}
