<?php
function get_fontawesome_icons() {
	$pattern = '/\.(fa-(?:\w+(?:-)?)+):before\s+{\s*content:\s*"(.+)";\s+}/';
	$subject = file_get_contents(CONATPLUGIN_PLUGIN_PATH . 'assets/fontawesome-all.css');
	preg_match_all($pattern, $subject, $matches, PREG_SET_ORDER);
	
	$icons = array();
	//fontawesome
	foreach($matches as $match)
	{
		$icons[] = array('value' => $match[1], 'label' => $match[1]);
	}
	
	//flaticon
	$et_matches = get_et_icons();
	foreach($et_matches as $match)
	{
		$icons[] = array('value' => $match[1], 'label' => $match[1]);
	}
	
	$icons = array_column($icons, 'label', 'value');
	return $icons;
}

function get_et_icons() {
	$pattern = '/\.(flaticon-(?:\w+(?:-)?)+):before\s*{\s*content/';
	$subject = file_get_contents(get_template_directory() . '/assets/css/flaticon_conat-flat.css');
	preg_match_all($pattern, $subject, $matches, PREG_SET_ORDER);
	return $matches;
}

//get all categories
function get_categories_list($taxonomy='category') {
    $options = array();
    if(!empty($taxonomy))
    {
        $terms = get_terms(
            array(
                'parent' => 0,
                'taxonomy' => $taxonomy,
                'hide_empty' => false,
            )
        );
        if (!empty($terms)) {
            foreach($terms as $term) {
                if (isset($term)) {
                    if (isset($term->slug) && isset($term->name)) {
                        $options[$term->slug] = $term->name.' ('.$term->count.')';
                    }
                }
            }
        }
    }
    return $options;
}

//Animation
function conat_animation() {
	return array(
		'' => 'None',
        'wow bounce' => 'bounce',
        'wow flash' => 'flash',
        'wow pulse' => 'pulse',
        'wow rubberBand' => 'rubberBand',
        'wow shake' => 'shake',
        'wow swing' => 'swing',
        'wow tada' => 'tada',
        'wow wobble' => 'wobble',
        'wow bounceIn' => 'bounceIn',
        'wow bounceInDown' => 'bounceInDown',
        'wow bounceInLeft' => 'bounceInLeft',
        'wow bounceInRight' => 'bounceInRight',
        'wow bounceInUp' => 'bounceInUp',
        'wow bounceOut' => 'bounceOut',
        'wow bounceOutDown' => 'bounceOutDown',
        'wow bounceOutLeft' => 'bounceOutLeft',
        'wow bounceOutRight' => 'bounceOutRight',
        'wow bounceOutUp' => 'bounceOutUp',
        'wow fadeIn' => 'fadeIn',
        'wow fadeInDown' => 'fadeInDown',
        'wow fadeInDownBig' => 'fadeInDownBig',
        'wow fadeInLeft' => 'fadeInLeft',
        'wow fadeInLeftBig' => 'fadeInLeftBig',
        'wow fadeInRight' => 'fadeInRight',
        'wow fadeInRightBig' => 'fadeInRightBig',
        'wow fadeInUp' => 'fadeInUp',
        'wow fadeInUpBig' => 'fadeInUpBig',
        'wow fadeOut' => 'fadeOut',
        'wow fadeOutDown' => 'fadeOutDown',
        'wow fadeOutDownBig' => 'fadeOutDownBig',
        'wow fadeOutLeft' => 'fadeOutLeft',
        'wow fadeOutLeftBig' => 'fadeOutLeftBig',
        'wow fadeOutRight' => 'fadeOutRight',
        'wow fadeOutRightBig' => 'fadeOutRightBig',
        'wow fadeOutUp' => 'fadeOutUp',
        'wow fadeOutUpBig' => 'fadeOutUpBig',
        'wow flip' => 'flip',
        'wow flipInX' => 'flipInX',
        'wow flipInY' => 'flipInY',
        'wow flipOutX' => 'flipOutX',
        'wow flipOutY' => 'flipOutY',
        'wow lightSpeedIn' => 'lightSpeedIn',
        'wow lightSpeedOut' => 'lightSpeedOut',
        'wow rotateIn' => 'rotateIn',
        'wow rotateInDownLeft' => 'rotateInDownLeft',
        'wow rotateInDownRight' => 'rotateInDownRight',
        'wow rotateInUpLeft' => 'rotateInUpLeft',
        'wow rotateInUpRight' => 'rotateInUpRight',
        'wow rotateOut' => 'rotateOut',
        'wow rotateOutDownLeft' => 'rotateOutDownLeft',
        'wow rotateOutDownRight' => 'rotateOutDownRight',
        'wow rotateOutUpLeft' => 'rotateOutUpLeft',
        'wow rotateOutUpRight' => 'rotateOutUpRight',
        'wow hinge' => 'hinge',
        'wow rollIn' => 'rollIn',
        'wow rollOut' => 'rollOut',
        'wow zoomIn' => 'zoomIn',
        'wow zoomInDown' => 'zoomInDown',
        'wow zoomInLeft' => 'zoomInLeft',
        'wow zoomInRight' => 'zoomInRight',
        'wow zoomInUp' => 'zoomInUp',
        'wow zoomOut' => 'zoomOut',
        'wow zoomOutDown' => 'zoomOutDown',
        'wow zoomOutLeft' => 'zoomOutLeft',
        'wow zoomOutRight' => 'zoomOutRight',
        'wow zoomOutUp' => 'zoomOutUp',
	);
}

//Post Order By
function conat_post_orderby() {
	return array(
		'date' => esc_html__( 'Date', 'conat' ),
		'title' => esc_html__( 'Title', 'conat' ),
		'menu_order' => esc_html__( 'Menu Order', 'conat' ),
		'rand' => esc_html__( 'Random', 'conat' ),
	);
}

//Post Ascending Descending
function conat_ascending_descending() {
	return array(
		'ASC' => esc_html__( 'Ascending', 'conat' ),
		'DESC' => esc_html__( 'Descending', 'conat' ),
	);
}

//Contact Form 7 List
function get_contact_form_7_list() {
	$contact_forms = array();
	$cf7 = get_posts( 'post_type="wpcf7_contact_form"&numberposts=-1' );
	if (!empty($cf7)) {
		foreach ($cf7 as $cform) {
			if (isset($cform)) {
				if (isset($cform->ID) && isset($cform->post_title)) {
					$contact_forms[$cform->ID] = $cform->post_title;
				}
			}
		}
	}
    return $contact_forms;
}

//Time
function conat_time_list() {
	return array(
		'12:00AM' => esc_html__('12:00AM', 'conat'),
		'12:30AM' => esc_html__('12:30AM', 'conat'),
		'01:00AM' => esc_html__('01:00AM', 'conat'),
		'01:30AM' => esc_html__('01:30AM', 'conat'),
		'02:00AM' => esc_html__('02:00AM', 'conat'),
		'02:30AM' => esc_html__('02:30AM', 'conat'),
		'03:00AM' => esc_html__('03:00AM', 'conat'),
		'03:30AM' => esc_html__('03:30AM', 'conat'),
		'04:00AM' => esc_html__('04:00AM', 'conat'),
		'04:30AM' => esc_html__('04:30AM', 'conat'),
		'05:00AM' => esc_html__('05:00AM', 'conat'),
		'05:30AM' => esc_html__('05:30AM', 'conat'),
		'06:00AM' => esc_html__('06:00AM', 'conat'),
		'06:30AM' => esc_html__('06:30AM', 'conat'),
		'07:00AM' => esc_html__('07:00AM', 'conat'),
		'07:30AM' => esc_html__('07:30AM', 'conat'),
		'08:00AM' => esc_html__('08:00AM', 'conat'),
		'08:30AM' => esc_html__('08:30AM', 'conat'),
		'09:00AM' => esc_html__('09:00AM', 'conat'),
		'09:30AM' => esc_html__('09:30AM', 'conat'),
		'10:00AM' => esc_html__('10:00AM', 'conat'),
		'10:30AM' => esc_html__('10:30AM', 'conat'),
		'11:00AM' => esc_html__('11:00AM', 'conat'),
		'11:30AM' => esc_html__('11:30AM', 'conat'),
		'12:00PM' => esc_html__('12:00PM', 'conat'),
		'12:30PM' => esc_html__('12:30PM', 'conat'),
		'01:00PM' => esc_html__('01:00PM', 'conat'),
		'01:30PM' => esc_html__('01:30PM', 'conat'),
		'02:00PM' => esc_html__('02:00PM', 'conat'),
		'02:30PM' => esc_html__('02:30PM', 'conat'),
		'03:00PM' => esc_html__('03:00PM', 'conat'),
		'03:30PM' => esc_html__('03:30PM', 'conat'),
		'04:00PM' => esc_html__('04:00PM', 'conat'),
		'04:30PM' => esc_html__('04:30PM', 'conat'),
		'05:00PM' => esc_html__('05:00PM', 'conat'),
		'05:30PM' => esc_html__('05:30PM', 'conat'),
		'06:00PM' => esc_html__('06:00PM', 'conat'),
		'06:30PM' => esc_html__('06:30PM', 'conat'),
		'07:00PM' => esc_html__('07:00PM', 'conat'),
		'07:30PM' => esc_html__('07:30PM', 'conat'),
		'08:00PM' => esc_html__('08:00PM', 'conat'),
		'08:30PM' => esc_html__('08:30PM', 'conat'),
		'09:00PM' => esc_html__('09:00PM', 'conat'),
		'09:30PM' => esc_html__('09:30PM', 'conat'),
		'10:00PM' => esc_html__('10:00PM', 'conat'),
		'10:30PM' => esc_html__('10:30PM', 'conat'),
		'11:00PM' => esc_html__('11:00PM', 'conat'),
		'11:30PM' => esc_html__('11:30PM', 'conat'),
	);
}

//Pagination
function conat_the_pagination2($args = array(), $echo = 1) {
	global $wp_query;
	
	$default =  array('base' => str_replace( 99999, '%#%', esc_url( get_pagenum_link( 99999 ) ) ), 'format' => '?paged=%#%', 'current' => max( 1, get_query_var('paged') ), 'total' => $wp_query->max_num_pages, 'next_text' => '&raquo;', 'prev_text' => '&laquo;', 'type'=>'list','add_args' => false);
						
	$args = wp_parse_args($args, $default);
	
	$pagination = str_replace("<ul class='page-numbers'", '<ul class="styled-pagination text-center"', paginate_links($args) );
	
	if(paginate_links(array_merge(array('type'=>'array'),$args)))
	{
		if($echo) echo wp_kses_post($pagination);
		return $pagination;
	}
}

add_filter('conat_redux_custom_fonts_load', 'conat_redux_custom_fonts_load');
function conat_redux_custom_fonts_load( $custom_font ) {
	$custom_style = '';
	$pathinfo = pathinfo( $custom_font );
	if ( $filename = conat_set( $pathinfo, 'filename' ) ) {
		$custom_style .= '@font-face{
            font-family:"' . $filename . '";';
		$extensions   = array( 'eot', 'woff', 'woff2', 'ttf', 'svg' );
		$count        = 0;
		foreach ( $extensions as $extension ) {
			$file_path = esc_url(home_url('/')) . '/wp-content/themes/conat/assets/css/custom-fonts/' . $filename . '.' . $extension;
			$file_url = esc_url(get_template_directory_uri()) . '/assets/css/custom-fonts/' . $filename . '.' . $extension;
			if ( $file_path ) {
				$format = $extension;
				if ( $extension === 'eot' ) {
					$format = 'embedded-opentype';
				}
				if ( $extension === 'ttf' ) {
					$format = 'truetype';
				}
				$terminated   = ( $count > 0 ) ? ';' : '';
				$custom_style .= $terminated . 'src:url("' . $file_url . '") format("' . $format . '")';
				$count ++;
			}
		}
		$custom_style .= ';}';
	}
	return $custom_style;
}
/**
 * [conat_social_share_output description]
 *
 * @param  [type] $comment [description].
 * @param  [type] $args    [description].
 * @param  [type] $depth   [description].
 *
 * @return void          [description]
 */
function conat_social_share_output( $icon, $color = false ) {
	$permalink = get_permalink( get_the_ID() );
	$titleget  = get_the_title();
	$allowed_html = wp_kses_allowed_html( 'post' );
	if ( $icon == 'facebook' ) {
		$fb = ( $color == 1 ) ? 'style="color:#3b5998"' : '';
		?>
		<li>
			<a onClick="window.open('http://www.facebook.com/sharer.php?u=<?php echo esc_url( $permalink ); ?>', 'Facebook', 'width=600,height=300,left=' + (screen.availWidth / 2 - 300) + ',top=' + (screen.availHeight / 2 - 150) + '');
					return false;" href="http://www.facebook.com/sharer.php?u=<?php echo esc_url( $permalink ); ?>">
				<i class="fa fa-facebook" <?php echo wp_kses( $fb, $allowed_html ); ?>></i>
			</a>
		</li>
	<?php } ?>
	<?php
	if ( $icon == 'twitter' ) {
		$twitter = ( $color == 1 ) ? 'style="color:#00aced"' : '';
		?>
		<li>
			<a onClick="window.open('http://twitter.com/share?url=<?php echo esc_url( $permalink ); ?>&amp;text=<?php echo str_replace( " ", "%20", $titleget ); ?>', 'Twitter share', 'width=600,height=300,left=' + (screen.availWidth / 2 - 300) + ',top=' + (screen.availHeight / 2 - 150) + '');
					return false;" href="http://twitter.com/share?url=<?php echo esc_url( $permalink ); ?>&amp;text=<?php echo str_replace( " ", "%20", $titleget ); ?>">
				<i class="fa fa-twitter" <?php echo wp_kses( $twitter, $allowed_html ); ?>></i>
			</a>
		</li>
	<?php } ?>
	
	<?php
	if ( $icon == 'digg' ) {
		$digg = ( $color == 1 ) ? 'style="color:#000000"' : '';
		?>
		<li>
			<a onClick="window.open('http://www.digg.com/submit?url=<?php echo esc_url( $permalink ); ?>', 'Digg', 'width=715,height=330,left=' + (screen.availWidth / 2 - 357) + ',top=' + (screen.availHeight / 2 - 165) + '');
					return false;" href="http://www.digg.com/submit?url=<?php echo esc_url( $permalink ); ?>">
				<i class="fa fa-digg" <?php echo wp_kses( $digg, $allowed_html ); ?>></i>
			</a>
		</li>
	<?php } ?>
	<?php
	if ( $icon == 'reddit' ) {
		$reddit = ( $color == 1 ) ? 'style="color:#ff5700"' : '';
		?>
		<li>
			<a onClick="window.open('http://reddit.com/submit?url=<?php echo esc_url( $permalink ); ?>&amp;title=<?php echo str_replace( " ", "%20", $titleget ); ?>', 'Reddit', 'width=617,height=514,left=' + (screen.availWidth / 2 - 308) + ',top=' + (screen.availHeight / 2 - 257) + '');
					return false;" href="http://reddit.com/submit?url=<?php echo esc_url( $permalink ); ?>&amp;title=<?php echo str_replace( " ", "%20", $titleget ); ?>">
				<i class="fa fa-reddit" <?php echo wp_kses( $reddit, $allowed_html ); ?>></i>
			</a>
		</li>
	<?php } ?>
	<?php
	if ( $icon == 'linkedin' ) {
		$linkeding = ( $color == 1 ) ? 'style="color:#007bb6"' : '';
		?>
		<li>
			<a onClick="window.open('http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo esc_url( $permalink ); ?>', 'Linkedin', 'width=863,height=500,left=' + (screen.availWidth / 2 - 431) + ',top=' + (screen.availHeight / 2 - 250) + '');
					return false;" href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo esc_url( $permalink ); ?>">
				<i class="fa fa-linkedin" <?php echo wp_kses( $linkeding, $allowed_html ); ?>></i>
			</a>
		</li>
	<?php } ?>
	<?php if ( $icon == 'pinterest' ) {
		$pinterest = ( $color == 1 ) ? 'style=color:#cb2027' : '';
		?>
		<li>
			<a href='javascript:void((function(){var e=document.createElement(&apos;script&apos;);e.setAttribute(&apos;type&apos;,&apos;text/javascript&apos;);e.setAttribute(&apos;charset&apos;,&apos;UTF-8&apos;);e.setAttribute(&apos;src&apos;,&apos;http://assets.pinterest.com/js/pinmarklet.js?r=&apos;+Math.random()*99999999);document.body.appendChild(e)})())'>
				<i class="fa fa-pinterest" <?php echo wp_kses( $pinterest, $allowed_html ); ?>></i></a>
		</li>
	<?php } ?>
	<?php
	if ( $icon == 'stumbleupon' ) {
		$stumbleupon = ( $color == 1 ) ? 'style="color:#EB4823"' : '';
		?>
		<li>
			<a onClick="window.open('http://www.stumbleupon.com/submit?url=<?php echo esc_url( $permalink ); ?>&amp;title=<?php echo str_replace( " ", "%20", $titleget ); ?>', 'Stumbleupon', 'width=600,height=300,left=' + (screen.availWidth / 2 - 300) + ',top=' + (screen.availHeight / 2 - 150) + '');
					return false;" href="http://www.stumbleupon.com/submit?url=<?php echo esc_url( $permalink ); ?>&amp;title=<?php echo str_replace( " ", "%20", $titleget ); ?>">
				<i class="fa fa-stumbleupon" <?php echo wp_kses( $stumbleupon, $allowed_html ); ?>></i>
			</a>
		</li>
	<?php } ?>
	<?php
	if ( $icon == 'tumblr' ) {
		$tumblr = ( $color == 1 ) ? 'style="color:#32506d"' : '';
		$str    = $permalink;
		$str    = preg_replace( '#^https?://#', '', $str );
		?>
		<li>
			<a onClick="window.open('http://www.tumblr.com/share/link?url=<?php echo esc_attr( $str ); ?>&amp;name=<?php echo str_replace( " ", "%20", $titleget ); ?>', 'Tumblr', 'width=600,height=300,left=' + (screen.availWidth / 2 - 300) + ',top=' + (screen.availHeight / 2 - 150) + '');
					return false;" href="http://www.tumblr.com/share/link?url=<?php echo esc_attr( $str ); ?>&amp;name=<?php echo str_replace( " ", "%20", $titleget ); ?>">
				<i class="fa fa-tumblr" <?php echo wp_kses( $tumblr, $allowed_html ); ?>></i>
			</a>
		</li>
	<?php } ?>
	<?php
	if ( $icon == 'email' ) {
		$mail = ( $color == 1 ) ? 'style="color:#000000"' : '';
		?>
		<li>
			<a href="mailto:?Subject=<?php echo str_replace( " ", "%20", $titleget ); ?>&amp;Body=<?php echo esc_url( $permalink ); ?>"><i class="fa fa-envelope-o" <?php echo wp_kses( $mail, $allowed_html ); ?>></i></a>
		</li>
		<?php
	}
}
add_action('conat_social_share_output', 'conat_social_share_output');

function conat_share_us($PostID = '', $PostName = '')
{
$options = conat_WSH()->option();
?>
<ul class="social-box">
	<li><span><?php esc_html_e('Share:', 'conat'); ?></span></li>
    
	<?php if($options->get( 'facebook_sharing' )):?>
	<li><a href="http://www.facebook.com/sharer.php?u=<?php echo esc_url(get_permalink($PostID)); ?>" target="_blank" class="fa-brands fa fa-facebook-f"></a></li>
	<?php endif;?>

	<?php if($options->get( 'twitter_sharing' )):?>
	<li><a href="https://twitter.com/share?url=<?php echo esc_url(get_permalink($PostID)); ?>&text=<?php echo esc_attr($post_slug=$PostName); ?>" target="_blank" class="fa-brands fa fa-twitter"></a></li>
	<?php endif;?>

	<?php if($options->get( 'linkedin_sharing' )):?>
	<li><a href="http://www.linkedin.com/shareArticle?url=<?php echo esc_url(get_permalink($PostID)); ?>&title=<?php echo esc_attr($post_slug=$PostName); ?>" target="_blank" class="fa-brands fa fa-linkedin"></a></li>
	<?php endif;?>

	<?php if($options->get( 'pinterest_sharing' )):?>
	<li><a href="https://pinterest.com/pin/create/bookmarklet/?url=<?php echo esc_url(get_permalink($PostID)); ?>&description=<?php echo esc_attr($post_slug=$PostName); ?>" target="_blank" class="fa-brands fa fa-pinterest"></a></li>
	<?php endif;?>

	<?php if($options->get( 'reddit_sharing' )):?>
	<li><a href="http://reddit.com/submit?url=<?php echo esc_url(get_permalink($PostID)); ?>&title=<?php echo esc_attr($post_slug=$PostName); ?>" target="_blank" class="fa-brands fa fa-reddit"></a></li>
	<?php endif;?>

	<?php if($options->get( 'tumblr_sharing' )):?>
	<li><a href="http://www.tumblr.com/share/link?url=<?php echo esc_url(get_permalink($PostID)); ?>&name=<?php echo esc_attr($post_slug=$PostName); ?>" target="_blank" class="fa-brands fa fa-tumblr"></a></li>
	<?php endif;?>

	<?php if($options->get( 'digg_sharing' )):?>
	<li><a href="http://digg.com/submit?url=<?php echo esc_url(get_permalink($PostID)); ?>&title=<?php echo esc_attr($post_slug=$PostName); ?>" target="_blank" class="fa-brands fa fa-digg"></a></li>
	<?php endif;?>
</ul>
<?php }

function conat_get_social_icons2()
{
	$options = conat_WSH()->option();
?>
    
    <?php $icons = $options->get( 'icons_social_share' );
		if ( !empty( $icons ) ) : ?>
		<?php foreach ( $icons as $h_icon ) :
        $header_social_icons = json_decode( urldecode( conat_set( $h_icon, 'data' ) ) );
        if ( conat_set( $header_social_icons, 'enable' ) == '' ) {
            continue;
        }
        $icon_class = explode( '-', conat_set( $header_social_icons, 'icon' ) ); ?>
        <a href="<?php echo esc_url(conat_set( $header_social_icons, 'url' )); ?>" class="fa-brands <?php echo esc_attr( conat_set( $header_social_icons, 'icon' ) ); ?>"></a>
        <?php endforeach; ?>
	<?php endif; ?>
<?php }

function conat_get_social_icons3()
{
	$options = conat_WSH()->option();
?>
    
    <?php $icons = $options->get( 'icons_social_share' );
		if ( !empty( $icons ) ) : ?>
		<?php foreach ( $icons as $h_icon ) :
        $header_social_icons = json_decode( urldecode( conat_set( $h_icon, 'data' ) ) );
        if ( conat_set( $header_social_icons, 'enable' ) == '' ) {
            continue;
        }
        $icon_class = explode( '-', conat_set( $header_social_icons, 'icon' ) ); ?>
        <li><a href="<?php echo esc_url(conat_set( $header_social_icons, 'url' )); ?>" class="fa-brands <?php echo esc_attr( conat_set( $header_social_icons, 'icon' ) ); ?>"></a></li>
        <?php endforeach; ?>
	<?php endif; ?>
<?php }

function conat_share_us_three($PostID = '', $PostName = '')
{
$options = conat_WSH()->option();
?>
<ul class="social-box">
	<?php if($options->get( 'project_facebook_sharing' )):?>
    <li><a href="http://www.facebook.com/sharer.php?u=<?php echo esc_url(get_permalink($PostID)); ?>" target="_blank" class="fa-brands fa-fw fa-facebook-f"></a></li>
    <?php endif; ?>

    <?php if($options->get( 'project_twitter_sharing' )):?>
    <li><a href="https://twitter.com/share?url=<?php echo esc_url(get_permalink($PostID)); ?>&text=<?php echo esc_attr($post_slug=$PostName); ?>" target="_blank" class="fa-brands fa-fw fa-twitter"></a></li>
    <?php endif; ?>

    <?php if($options->get( 'project_linkedin_sharing' )):?>
    <li><a href="http://www.linkedin.com/shareArticle?url=<?php echo esc_url(get_permalink($PostID)); ?>&title=<?php echo esc_attr($post_slug=$PostName); ?>" target="_blank" class="fa-brands fa-fw fa-linkedin"></a></li>
    <?php endif; ?>

    <?php if($options->get( 'project_pinterest_sharing' )):?>
    <li><a href="https://pinterest.com/pin/create/bookmarklet/?url=<?php echo esc_url(get_permalink($PostID)); ?>&description=<?php echo esc_attr($post_slug=$PostName); ?>" target="_blank" class="fa-brands fa-fw fa-pinterest-p"></a></li>
    <?php endif; ?>

    <?php if($options->get( 'project_reddit_sharing' )):?>
    <li><a href="http://reddit.com/submit?url=<?php echo esc_url(get_permalink($PostID)); ?>&title=<?php echo esc_attr($post_slug=$PostName); ?>" target="_blank" class="fa-brands fa-fw fa-reddit"></a></li>
    <?php endif; ?>

    <?php if($options->get( 'project_tumblr_sharing' )):?>
    <li><a href="http://www.tumblr.com/share/link?url=<?php echo esc_url(get_permalink($PostID)); ?>&name=<?php echo esc_attr($post_slug=$PostName); ?>" target="_blank" class="fa-brands fa-fw fa-tumblr"></a></li>
    <?php endif; ?>

    <?php if($options->get( 'project_digg_sharing' )):?>
    <li><a href="http://digg.com/submit?url=<?php echo esc_url(get_permalink($PostID)); ?>&title=<?php echo esc_attr($post_slug=$PostName); ?>" target="_blank" class="fa-brands fa-fw fa-digg"></a></li>
    <?php endif; ?>
</ul>
<?php }

//Show Featured Image Column
if(!function_exists('conat_add_post_admin_thumbnail_column')) {
	add_image_size('conat-admin-post-featured-image', 60, 60, true);
	add_filter('manage_post_posts_columns', 'conat_add_post_admin_thumbnail_column', 2);
	add_filter('manage_project_posts_columns', 'conat_add_post_admin_thumbnail_column', 2);
	add_filter('manage_service_posts_columns', 'conat_add_post_admin_thumbnail_column', 2);
	add_filter('manage_department_posts_columns', 'conat_add_post_admin_thumbnail_column', 2);
	add_filter('manage_doctor_posts_columns', 'conat_add_post_admin_thumbnail_column', 2);
	add_filter('manage_testimonials_posts_columns', 'conat_add_post_admin_thumbnail_column', 2);
	
	function conat_add_post_admin_thumbnail_column($conat_columns){
		$conat_columns['post_thumb'] = __('Featured Image', 'conat');

		return $conat_columns;
	}
}

if(!function_exists('conat_show_post_thumbnail_column')) {
	add_action('manage_post_posts_custom_column', 'conat_show_post_thumbnail_column', 5, 2);
	add_action('manage_project_posts_custom_column', 'conat_show_post_thumbnail_column', 5, 2);
	add_action('manage_service_posts_custom_column', 'conat_show_post_thumbnail_column', 5, 2);
	add_action('manage_department_posts_custom_column', 'conat_show_post_thumbnail_column', 5, 2);
	add_action('manage_doctor_posts_custom_column', 'conat_show_post_thumbnail_column', 5, 2);
	add_action('manage_testimonials_posts_custom_column', 'conat_show_post_thumbnail_column', 5, 2);

	function conat_show_post_thumbnail_column($conat_columns, $portfolio_id){
		switch($conat_columns) {
			case 'post_thumb':
				if(function_exists('the_post_thumbnail')) {
					the_post_thumbnail('conat-admin-post-featured-image');
				} else {
					echo 'hmm... your theme doesn\'t support featured image...';
				}
				break;
		}
	}
}

function conat_icon_type() {
	return array(
		'' => esc_html__('Select Icon', 'conat'),
		'flaticon' => esc_html__('Flaticon', 'conat'),
		'icon' => esc_html__('Icon', 'conat'),
		'icon_image' => esc_html__('Icon Image', 'conat'),
	);
}
