<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Video extends Widget_Base {

    public function get_name() {
        return 'conat_video';
    }

    public function get_title() {
        return esc_html__( 'Conat Video', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => __( 'Backgruond Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$this->add_control(
            'pattern_image1',
            [
                'label' => __( 'Pattern Left Top', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$this->add_control(
            'pattern_image2',
            [
                'label' => __( 'Pattern Left Bottom', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$this->add_control(
            'pattern_image3',
            [
                'label' => __( 'Pattern Right Top', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$this->add_control(
            'pattern_image4',
            [
                'label' => __( 'Pattern Right Bottom', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
		$this->add_control(
            'text',
            [
                'label' => __( 'Text', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->end_controls_section();
		
		//Video
		$this->start_controls_section(
            'video_tab',
            [
                'label' => esc_html__( 'Video', 'conat' ),
            ]
        );
        $this->add_control(
            'video_url',
            [
                'label' => __( 'Video URL', 'conat' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'https://your-link.com', 'conat' ),
				'label_block' => true,
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		?>
        
        <!-- Video One -->
        <section class="video-one" <?php if($settings['bg_image']['id']) { ?>style="background-image: url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>)"<?php } ?>>
            <?php if($settings['pattern_image1']['id']) { ?><div class="video-one_pattern-one" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_image1']['id'])); ?>)"></div><?php } ?>
            <?php if($settings['pattern_image2']['id']) { ?><div class="video-one_pattern-two" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_image2']['id'])); ?>)"></div><?php } ?>
            <?php if($settings['pattern_image3']['id']) { ?><div class="video-one_pattern-three" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_image3']['id'])); ?>)"></div><?php } ?>
            <?php if($settings['pattern_image4']['id']) { ?><div class="video-one_pattern-four" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_image4']['id'])); ?>)"></div><?php } ?>
            <div class="auto-container">
                <div class="sec-title title-anim light centered">
                    <div class="sec-title_title"><?php echo wp_kses( $settings['title'], true ); ?></div>
                    <h2 class="sec-title_heading"><?php echo wp_kses( $settings['text'], true ); ?></h2>
                    <?php if($settings['video_url']) { ?>
                    <a href="<?php echo esc_url($settings['video_url']); ?>" class="lightbox-video video-one_play"><span class="fa fa-play"><i class="ripple"></i></span></a>
                    <?php } ?>
                </div>
            </div>
        </section>
        <!-- End Video One -->
        
        <?php
    }
}
