<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Thought_Leadership_V4 extends Widget_Base {

	public function get_name() {
		return 'conat_thought_leadership_v4';
	}

	public function get_title() {
		return esc_html__( 'Conat Thought Leadership V4', 'conat' );
	}

	public function get_icon() {
		return 'tr-custom-icon';
	}

	public function get_categories() {
		return [ 'conat' ];
	}
	
	public function get_script_depends() {
		wp_register_script( 'tabs', TR_URL . 'assets/js/tabs.js', [ 'elementor-frontend' ], TR_VERSION, true );
		return [ 'tabs' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'left_bg_image',
            [
                'label' => __( 'Left Background Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'right_bg_image',
            [
                'label' => __( 'Right Background Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'text',
            [
                'label' => __( 'Text', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->end_controls_section();
		
		//Query
		$this->start_controls_section(
            'query_tab',
            [
                'label' => esc_html__( 'Query', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'tab_date',
			[
				'label' => __( 'Tab Date', 'conat' ),
				'type' => Controls_Manager::DATE_TIME,
			]
		);
		$repeater->add_control(
			'tab_title',
			[
				'label' => __( 'Tab Title', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'conat' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$repeater->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'conat' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'conat' ),
					'title'      => esc_html__( 'Title', 'conat' ),
					'menu_order' => esc_html__( 'Menu Order', 'conat' ),
					'rand'       => esc_html__( 'Random', 'conat' ),
				),
			]
		);
		$repeater->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'conat' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'ASC',
				'options' => array(
					'ASC' => esc_html__( 'Ascending', 'conat' ),
					'DESC' => esc_html__( 'Descending', 'conat' ),
				),
			]
		);
		$repeater->add_control(
			'query_category',
			[
			  'label' => esc_html__('Category', 'conat'),
			  'type' => Controls_Manager::SELECT,
			  'options' => get_categories_list('tribe_events_cat')
			]
		);
		$this->add_control(
			'event_tab',
			[
				'label'       => __( 'Event Tabs', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ tab_title }}}',
			]
		);
		$this->end_controls_section();
		
		//Button
		$this->start_controls_section(
            'button_tab',
            [
                'label' => esc_html__( 'Button', 'conat' ),
            ]
        );
		$this->add_control(
            'btn_style',
            [
                'label' => esc_html__('Style', 'conat'),
                'type' => Controls_Manager::SELECT2,
                'default' => 'one',
                'options' => conat_button_style(),
            ]
        );
        $this->add_control(
            'btn_name',
            [
                'label' => __( 'Name', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => __( 'Link', 'conat' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'conat' ),
                'show_external' => true,
                'dynamic'  => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
            ]
        );
        $this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	 protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>
        
        <!-- Event Schedule Section-->
        <section class="event-schedule-section">
            <?php if($settings['left_bg_image']['id']) { ?><div class="circle-layer" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['left_bg_image']['id'])); ?>)"></div><?php } ?>
            <?php if($settings['right_bg_image']['id']) { ?><div class="shape-icon" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['right_bg_image']['id'])); ?>)"></div><?php } ?>
            <div class="auto-container">
                <!-- Sec Title -->
                <div class="sec-title centered">
                    <div class="sec-title_title"><?php echo wp_kses($settings['subtitle'], true); ?></div>
                    <h2 class="sec-title_heading"><?php echo wp_kses($settings['title'], true); ?></h2>
                    <div class="sec-title_text"><?php echo wp_kses($settings['text'], true); ?></div>
                </div>
                
                <div class="schedule-tabs tabs-box">
                    <div class="btns-box">
                        <!--Tabs Box-->
                        <ul class="tab-buttons clearfix">
                            <?php $i=1; foreach($settings['event_tab'] as $key => $item): ?>
                            <li data-tab="#speaker4-<?php echo esc_attr($i); ?>" class="tab-btn <?php if($i == 1) echo 'active-btn'; ?>">
                                <span class="day"><?php echo wp_kses($item['tab_title'], true); ?></span>
                                <span class="date"><?php echo wp_kses(date("d", strtotime($item['tab_date'])), true); ?></span> 
                                <span class="month"><?php echo wp_kses(date("M", strtotime($item['tab_date'])), true); ?></span> <?php echo wp_kses(date("Y", strtotime($item['tab_date'])), true); ?>
                            </li>
                            <?php $i++; endforeach; ?>
                        </ul>
                    </div>
    
                    <div class="tabs-content">
                        <?php $j=1; foreach($settings['event_tab'] as $keys => $item):
                            $paged = conat_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;
                            $this->add_render_attribute( 'wrapper', 'class', 'templatepath-conat' );
                            $args = array(
                                'post_type'      => 'tribe_events',
                                'posts_per_page' => conat_set( $item, 'query_number' ),
                                'orderby'        => conat_set( $item, 'query_orderby' ),
                                'order'          => conat_set( $item, 'query_order' ),
                                'paged'          => $paged
                            );
                            if ( conat_set( $item, 'query_exclude' ) ) {
                                $item['query_exclude'] = explode( ',', $item['query_exclude'] );
                                $args['post__not_in']      = conat_set( $item, 'query_exclude' );
                            }
                            if( conat_set( $item, 'query_category' ) ) $args['tribe_events_cat'] = conat_set( $item, 'query_category' );
                            $query = new \WP_Query( $args );
                        if ( $query->have_posts()):	?>
                        <!--Tab-->
                        <div class="tab <?php if($j == 1) echo 'active-tab'; ?>" id="speaker4-<?php echo esc_attr($j); ?>">
                            <div class="schedule-timeline">
                                <?php global $post; $i = 1;
								while ( $query->have_posts() ) : $query->the_post();

								$start_datetime = tribe_get_start_date(get_the_id());
								$end_datetime = tribe_get_end_date(get_the_id());

								$start_date = tribe_get_start_date(get_the_id(), null, false, 'd' );
								$end_date = tribe_get_end_date(get_the_id(), null, false, 'd M, Y' );

								$start_time = tribe_get_start_time ( get_the_id(), 'h:i A' );
								$end_time = tribe_get_end_time ( get_the_id(), 'h:i A' );
								
								$location = get_option('location');
								$term_list = wp_get_post_terms($post->ID, 'tribe_events_cat', array("fields" => "names")); ?>
                                <!-- Schedule Block -->
                                <div class="schedule-block">
                                    <div class="inner-box">
                                        <div class="content">
                                            <div class="author-box">
                                                <div class="box-inner">
                                                	<?php $speaker_image = get_post_meta( get_the_id(), 'speaker_image', true );
													if($speaker_image) { ?>
                                                    <div class="author-image">
                                                        <img src="<?php echo esc_url(wp_get_attachment_url($speaker_image['id'])); ?>" alt="<?php esc_attr_e('Speaker Image', 'conat'); ?>">
                                                    </div>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                            <div class="date"><?php echo wp_kses($start_time, true); ?> -- <?php echo wp_kses($end_time, true); ?></div>
                                            <h4><a href="<?php echo esc_url(get_permalink(get_the_id())); ?>"><?php the_title(); ?></a></h4>
                                            <div class="text"><?php echo wp_kses(get_post_meta( get_the_id(), 'short_description', true ), true); ?></div>
                                            <ul class="event-info">
                                                <li><span class="icon flaticon-maps-and-flags"></span><?php echo wp_kses(tribe_get_venue(get_the_id()), true); ?></li>
                                            </ul>
                                            <div class="btns-box">
                                                <a href="<?php echo esc_url(get_permalink(get_the_id())); ?>" class="theme-btn btn-style-one">
                                                    <span class="btn-wrap">
                                                        <span class="text-one"><?php esc_html_e('View Details', 'conat'); ?></span>
                                                        <span class="text-two"><?php esc_html_e('View Details', 'conat'); ?></span>
                                                    </span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php $i++;
								endwhile; ?>
                            </div>
                        </div>
                        <?php $j++;
                            endif;
                        endforeach; ?>
                    </div>
                    
                </div>
                
                <?php if($settings['btn_link']['url'] and $settings['btn_name']) { ?>
                <div class="download-btns-box text-center">
                	<?php echo conat_button($settings['btn_style'], $settings['btn_name'], $settings['btn_link']['url']); ?>
                </div>
                <?php } ?>
            </div>
        </section>
        <!-- End Event Schedule Section-->
        
		<?php
		wp_reset_postdata();
	}
}
