<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Thought_Leadership_V3 extends Widget_Base {

	public function get_name() {
		return 'conat_thought_leadership_v3';
	}

	public function get_title() {
		return esc_html__( 'Conat Thought Leadership V3', 'conat' );
	}

	public function get_icon() {
		return 'tr-custom-icon';
	}

	public function get_categories() {
		return [ 'conat' ];
	}
	
	public function get_script_depends() {
		wp_register_script( 'tabs', TR_URL . 'assets/js/tabs.js', [ 'elementor-frontend' ], TR_VERSION, true );
		return [ 'tabs' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => __( 'Background Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->end_controls_section();
		
		//Query
		$this->start_controls_section(
            'query_tab',
            [
                'label' => esc_html__( 'Query', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'tab_date',
			[
				'label' => __( 'Tab Date', 'conat' ),
				'type' => Controls_Manager::DATE_TIME,
			]
		);
		$repeater->add_control(
			'tab_title',
			[
				'label' => __( 'Tab Title', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'conat' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$repeater->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'conat' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'conat' ),
					'title'      => esc_html__( 'Title', 'conat' ),
					'menu_order' => esc_html__( 'Menu Order', 'conat' ),
					'rand'       => esc_html__( 'Random', 'conat' ),
				),
			]
		);
		$repeater->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'conat' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'ASC',
				'options' => array(
					'ASC' => esc_html__( 'Ascending', 'conat' ),
					'DESC' => esc_html__( 'Descending', 'conat' ),
				),
			]
		);
		$repeater->add_control(
			'query_category',
			[
			  'label' => esc_html__('Category', 'conat'),
			  'type' => Controls_Manager::SELECT,
			  'options' => get_categories_list('tribe_events_cat')
			]
		);
		$this->add_control(
			'event_tab',
			[
				'label'       => __( 'Event Tabs', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ tab_title }}}',
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	 protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>
        
        <!-- Speakers Four -->
        <section class="speakers-four">
            <?php if($settings['bg_image']['id']) { ?><div class="speakers-four_pattern" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>)"></div><?php } ?>
            <div class="auto-container">
                <div class="sec-title">
                    <div class="sec-title_title"><?php echo wp_kses($settings['subtitle'], true); ?></div>
                    <h2 class="sec-title_heading"><?php echo wp_kses($settings['title'], true); ?></h2>
                </div>
                <div class="inner-container">
                    <!-- Speaker Info Tabs -->
                    <div class="speaker-info-tabs">
                        <!-- Speaker Tabs -->
                        <div class="speaker-tabs_two tabs-box">
                            <!-- Tab Btns -->
                            <ul class="tab-btns tab-buttons clearfix">
                            	<?php $i=1; foreach($settings['event_tab'] as $key => $item): ?>
                                <li data-tab="#speaker1-<?php echo esc_attr($i); ?>" class="tab-btn <?php if($i == 1) echo 'active-btn'; ?>"><span><?php echo wp_kses($item['tab_title'], true); ?></span> <?php echo wp_kses(date("M", strtotime($item['tab_date'])), true); ?> <strong><?php echo wp_kses(date("d", strtotime($item['tab_date'])), true); ?></strong><i><?php echo wp_kses(date("Y", strtotime($item['tab_date'])), true); ?></i></li>
                                <?php $i++; endforeach; ?>
                            </ul>
                            
                            <!-- Tabs Container -->
                            <div class="tabs-content">
                                <?php $j=1; foreach($settings['event_tab'] as $keys => $item):
									$paged = conat_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;
									$this->add_render_attribute( 'wrapper', 'class', 'templatepath-conat' );
									$args = array(
										'post_type'      => 'tribe_events',
										'posts_per_page' => conat_set( $item, 'query_number' ),
										'orderby'        => conat_set( $item, 'query_orderby' ),
										'order'          => conat_set( $item, 'query_order' ),
										'paged'          => $paged
									);
									if ( conat_set( $item, 'query_exclude' ) ) {
										$item['query_exclude'] = explode( ',', $item['query_exclude'] );
										$args['post__not_in']      = conat_set( $item, 'query_exclude' );
									}
									if( conat_set( $item, 'query_category' ) ) $args['tribe_events_cat'] = conat_set( $item, 'query_category' );
									$query = new \WP_Query( $args );
								if ( $query->have_posts()):	?>
                                <!-- Tab / Active Tab -->
                                <div class="tab <?php if($j == 1) echo 'active-tab'; ?>" id="speaker1-<?php echo esc_attr($j); ?>">
                                    <div class="content">
                                    	<?php global $post; $i = 1;
										while ( $query->have_posts() ) : $query->the_post();
		
										$start_datetime = tribe_get_start_date(get_the_id());
										$end_datetime = tribe_get_end_date(get_the_id());
		
										$start_date = tribe_get_start_date(get_the_id(), null, false, 'd' );
										$end_date = tribe_get_end_date(get_the_id(), null, false, 'd M, Y' );
		
										$start_time = tribe_get_start_time ( get_the_id(), 'h:i A' );
										$end_time = tribe_get_end_time ( get_the_id(), 'h:i A' );
										
										$location = get_option('location');
										$term_list = wp_get_post_terms($post->ID, 'tribe_events_cat', array("fields" => "names")); ?>
                                        <!-- Leadership One Ship -->
                                        <div class="leadership-three_block">
                                            <div class="leadership-three_block-inner">
                                                <div class="leadership-three_block-content">
                                                     <?php $speaker_image = get_post_meta( get_the_id(), 'speaker_image', true );
													if($speaker_image) { ?>
													<div class="leadership-three_block-image">
                                                        <img src="<?php echo esc_url(wp_get_attachment_url($speaker_image['id'])); ?>" alt="<?php esc_attr_e('Speaker Image', 'conat'); ?>">
                                                    </div>
                                                    <?php } ?>
                                                    <div class="leadership-three_block-name"><?php echo wp_kses(get_post_meta( get_the_id(), 'speaker_name', true ), true); ?>, <span><?php echo wp_kses(get_post_meta( get_the_id(), 'speaker_designation', true ), true); ?></span></div>
                                                    <h3 class="leadership-three_block-title"><a href="<?php echo esc_url(get_permalink(get_the_id())); ?>"><?php the_title(); ?></a></h3>
                                                    <?php if(tribe_get_venue(get_the_id())) { ?><div class="leadership-three_block-location"><span><?php esc_html_e('Location:', 'conat'); ?></span> <?php echo wp_kses(tribe_get_venue(get_the_id()), true); ?></div><?php } ?>
                                                    <div class="leadership-three_block-timing"><?php echo wp_kses($start_time, true); ?> <br> <?php echo wp_kses($end_time, true); ?></div>
                                                </div>
                                                
                                                <?php if( get_post_meta( get_the_id(), 'audio', true ) == 'sc_audio' ) {
													$sc_id = get_post_meta( get_the_id(), 'sc_id', true );
													$auto_play = get_post_meta( get_the_id(), 'auto_play', true );
												?>
												<a href="<?php echo esc_url('https://w.soundcloud.com/player/?visual=true&amp;url=https://api.soundcloud.com/tracks/'.esc_attr($sc_id).'&amp;show_artwork=true&amp;maxwidth=1020&amp;maxheight=1000&amp;auto_play='.esc_attr($auto_play).''); ?>" class="lightbox-audio mfp-iframe audio leadership-three_block-icon flaticon-voice"></a>
												<?php } else { ?>
												<div class="leadership-three_block-icon flaticon-voice"></div>
												<?php } ?>
                                            </div>
                                        </div>
                                        <?php $i++;
										endwhile; ?>
                                    </div>
                                </div>
                                <?php $j++;
									endif;
								endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End Speakers Four -->
        
		<?php
		wp_reset_postdata();
	}
}
