<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Testimonials_V1 extends Widget_Base {

    public function get_name() {
        return 'conat_testimonials_v1';
    }

    public function get_title() {
        return esc_html__( 'Conat Testimonials V1', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'two-item-carousel', TR_URL . 'assets/js/two-item-carousel.js', [ 'elementor-frontend' ], TR_VERSION, true );
		return [ 'two-item-carousel' ];
	}

    protected function _register_controls() {
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => __( 'Backgruond Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->end_controls_section();
		
		//Query
        $this->start_controls_section(
            'query_tab',
            [
                'label' => esc_html__( 'Query', 'conat' ),
            ]
        );
        $this->add_control(
            'text_limit',
            [
                'label' => esc_html__( 'Text Limit', 'conat' ),
                'type' => Controls_Manager::NUMBER,
                'default' => 25,
                'min'  => 1,
                'max'  => 100,
                'step' => 1,
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label' => esc_html__( 'Number of post', 'conat' ),
                'type' => Controls_Manager::NUMBER,
                'default' => 4,
                'min'  => 1,
                'max'  => 100,
                'step' => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label' => esc_html__( 'Order By', 'conat' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date' => esc_html__( 'Date', 'conat' ),
                    'title'   => esc_html__( 'Title', 'conat' ),
                    'menu_order' => esc_html__( 'Menu Order', 'conat' ),
                    'rand' => esc_html__( 'Random', 'conat' ),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label' => esc_html__( 'Order', 'conat' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'ASC' => esc_html__( 'Ascending', 'conat' ),
                    'DESC' => esc_html__( 'Descending', 'conat' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'label' => esc_html__('Category', 'conat'),
                'type' => Controls_Manager::SELECT,
                'options' => get_categories_list('testimonials_cat')
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

        $paged = get_query_var('paged');
		$paged = conat_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

        $this->add_render_attribute( 'wrapper', 'class', 'themerange-conat' );
        $args = array(
            'post_type' => 'testimonials',
            'posts_per_page' => conat_set( $settings, 'query_number' ),
            'orderby' => conat_set( $settings, 'query_orderby' ),
            'order' => conat_set( $settings, 'query_order' ),
            'paged' => $paged
        );

        if( conat_set( $settings, 'query_category' ) ) $args['testimonials_cat'] = conat_set( $settings, 'query_category' );
        $query = new \WP_Query( $args ); ?>
        
        <!-- Testimonial One -->
        <section class="testimonial-one">
            <?php if($settings['bg_image']['id']) { ?><div class="testimonial-one_pattern" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>)"></div><?php } ?>
            <div class="auto-container">
                <div class="sec-title">
                    <div class="sec-title_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                    <h2 class="sec-title_heading"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                </div>
                
                <?php if ( $query->have_posts() ) { ?>
                <div class="two-item-carousel owl-carousel owl-theme">
                	<?php while ( $query->have_posts() ) : $query->the_post(); ?>
                    <!-- Testimonial Block One -->
                    <div class="testimonial-block_one">
                        <div class="testimonial-block_one-inner">
                            <div class="testimonial-block_one-content">
                                <div class="testimonial-block_one-text"><?php echo wp_kses(conat_trim(get_the_content(), $settings['text_limit']), true); ?></div>
                                
                                <?php $rating = get_post_meta( get_the_id(), 'testimonial_rating', true );
								if(!empty($rating)){ ?>
                                <div class="testimonial-block_one-rating">
                                	<?php for ($x = 1; $x <= 5; $x++) {
										if($x <= $rating) echo '<span class="fa fa-star"></span>'; else echo '<span class="fa fa-star-o"></span>';
									} ?>
                                </div>
                                <?php } ?>
                                <div class="testimonial-block_one-quote flaticon-quote"></div>
                            </div>
                            <div class="testimonial-block_one-lower">
                            	<?php if (has_post_thumbnail()){ ?>
                                <div class="testimonial-block_one-author">
                                    <?php the_post_thumbnail('conat_120x120'); ?>
                                </div>
                                <?php } ?>
                                
                                <strong><?php the_title(); ?></strong>
                                <?php echo wp_kses(get_post_meta( get_the_id(), 'designation', true ), true); ?>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
                <?php }
				wp_reset_postdata(); ?>
            </div>
        </section>
        <!-- End Testimonial One -->
        
        <?php
    }
}
