<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Terms_and_Conditions extends Widget_Base {

    public function get_name() {
        return 'conat_terms_and_conditions';
    }

    public function get_title() {
        return esc_html__( 'Conat Terms & Conditions', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
        //Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
		$this->add_control(
            'text',
            [
                'label' => __( 'Text', 'conat' ),
                'type' => Controls_Manager::WYSIWYG,
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!-- Privacy Section -->
        <section class="privacy-section">
            <div class="auto-container">
                <!-- Privacy Content -->
                <div class="privacy-content">
                    <h3><?php echo wp_kses( $settings['title'], true ); ?></h3>
                    <?php echo wp_kses( $settings['text'], true ); ?>
                </div>
            </div>
        </section>
        <!-- End Privacy Section -->
        
        <?php
    }
}
