<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Subscriber extends Widget_Base {

    public function get_name() {
        return 'conat_subscriber';
    }

    public function get_title() {
        return esc_html__( 'Conat Subscriber', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
		$this->start_controls_section(
            'settings_tab',
            [
                'label' => esc_html__( 'Settings', 'conat' ),
            ]
        );
		$this->add_control(
            'style',
            [
                'label' => esc_html__( 'Style', 'conat' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'one',
                'options' => array(
                    'one' => esc_html__( 'Style One', 'conat' ),
                    'two' => esc_html__( 'Style Two', 'conat' ),
                ),
            ]
        );
		$this->end_controls_section();
		
		//Images
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => __( 'Backgruond Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'pattern_left_image',
            [
                'label' => __( 'Pattern Left Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
                    'style' => 'one'
                ]
            ]
        );
        $this->add_control(
            'pattern_right_image',
            [
                'label' => __( 'Pattern Right Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
                    'style' => 'one'
                ]
            ]
        );
        $this->end_controls_section();
		
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->end_controls_section();
		
		//Subscriber
        $this->start_controls_section(
            'subscriber_tab',
            [
                'label' => esc_html__( 'Subscriber Form', 'conat' ),
            ]
        );
        $this->add_control(
            'cf7_shortocde',
            [
                'label' => esc_html__('Select Form', 'conat'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => get_contact_form_7_list(),
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <?php if ($settings['style'] == 'one'){ ?>
        <!-- Subscribe One -->
        <section class="subscribe-one">
            <?php if($settings['bg_image']['id']) { ?><div class="subscribe-one_pattern-three" data-parallax='{"y" : 50}' style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>)"></div><?php } ?>
            <div class="auto-container">
                <div class="inner-container">
                    <?php if($settings['pattern_left_image']['id']) { ?><div class="subscribe-one_pattern" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_left_image']['id'])); ?>)"></div><?php } ?>
                    <?php if($settings['pattern_right_image']['id']) { ?><div class="subscribe-one_pattern-two" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_right_image']['id'])); ?>)"></div><?php } ?>
                    <div class="row clearfix">
                        <div class="subscribe-one_title-column col-lg-6 col-md-12 col-sm-12">
                            <div class="subscribe-one_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                            <h3 class="subscribe-one_heading"><?php echo wp_kses( $settings['title'], true ); ?></h3>
                        </div>
                        
                        <!-- Form Column -->
                        <div class="form-column col-lg-6 col-md-12 col-sm-12">
                            <?php if ($settings['cf7_shortocde']){ ?>
                            <!-- Subscribe Box -->
                            <div class="subscribe-box">
                                <?php echo do_shortcode('[contact-form-7 id="'.esc_attr($settings['cf7_shortocde']).'"]'); ?>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End Subscribe One -->
        
        <?php } else { ?>
        
        <!-- Subscribe One -->
        <section class="subscribe-two" <?php if($settings['bg_image']['id']) { ?>style="background-image: url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>)"<?php } ?>>
            <div class="auto-container">
                <div class="inner-container">
                    <div class="row clearfix">
                        <div class="subscribe-two_title-column col-lg-6 col-md-12 col-sm-12">
                            <div class="subscribe-two_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                            <h3 class="subscribe-two_heading"><?php echo wp_kses( $settings['title'], true ); ?></h3>
                        </div>
                        
                        <!-- Form Column -->
                        <div class="form-column col-lg-6 col-md-12 col-sm-12">
                            <?php if ($settings['cf7_shortocde']){ ?>
                            <!-- Subscribe Box -->
                            <div class="subscribe-box style-two">
                                <?php echo do_shortcode('[contact-form-7 id="'.esc_attr($settings['cf7_shortocde']).'"]'); ?>
                            </div>
                            <?php } ?>
                        </div>
                        
                    </div>
                </div>
            </div>
        </section>
        <!-- End Subscribe One -->
        <?php } ?>
        
        <?php
    }
}
