<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Speaker_V2 extends Widget_Base {

    public function get_name() {
        return 'conat_speaker_v2';
    }

    public function get_title() {
        return esc_html__( 'Conat Speaker V2', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->end_controls_section();
		
		//Query
        $this->start_controls_section(
            'query_tab',
            [
                'label' => esc_html__( 'Query', 'conat' ),
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label' => esc_html__( 'Number of post', 'conat' ),
                'type' => Controls_Manager::NUMBER,
                'default' => 6,
                'min'  => 1,
                'max'  => 100,
                'step' => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label' => esc_html__( 'Order By', 'conat' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date' => esc_html__( 'Date', 'conat' ),
                    'title'   => esc_html__( 'Title', 'conat' ),
                    'menu_order' => esc_html__( 'Menu Order', 'conat' ),
                    'rand' => esc_html__( 'Random', 'conat' ),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label' => esc_html__( 'Order', 'conat' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'ASC' => esc_html__( 'Ascending', 'conat' ),
                    'DESC' => esc_html__( 'Descending', 'conat' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'label' => esc_html__('Category', 'conat'),
                'type' => Controls_Manager::SELECT,
                'options' => get_categories_list('speaker_cat')
            ]
        );
        $this->end_controls_section();
		
		//Settings
		$this->start_controls_section(
            'setting_tab',
            array(
                'label' => esc_html__( 'Settings', 'conat' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            )
        );
		$this->add_control(
			'show_link',
			array(
				'label' => esc_html__( 'Show Link', 'conat' ),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => array(
					'0'	=> esc_html__( 'No', 'conat' ),
					'1'	=> esc_html__( 'Yes', 'conat' ),
				),
			)
		);
		$this->add_control(
            'show_social_media',
            array(
                'label' => esc_html__('Show Social Media', 'conat'),
                'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => array(
					'0'	=> esc_html__( 'No', 'conat' ),
					'1'	=> esc_html__( 'Yes', 'conat' ),
				),
            )
        );
		$this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

        $paged = get_query_var('paged');
		$paged = conat_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

        $this->add_render_attribute( 'wrapper', 'class', 'themerange-conat' );
        $args = array(
            'post_type' => 'speaker',
            'posts_per_page' => conat_set( $settings, 'query_number' ),
            'orderby' => conat_set( $settings, 'query_orderby' ),
            'order' => conat_set( $settings, 'query_order' ),
            'paged' => $paged
        );

        if( conat_set( $settings, 'query_category' ) ) $args['speaker_cat'] = conat_set( $settings, 'query_category' );
        $query = new \WP_Query( $args ); ?>
        
        <!-- Team One -->
        <section class="team-one">
            <div class="auto-container">
                <div class="sec-title title-anim centered">
                    <div class="sec-title_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                    <h2 class="sec-title_heading"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                </div>
                
                <?php if ( $query->have_posts() ) { ?>
                <div class="row clearfix">
                	<?php while($query->have_posts()) : $query->the_post(); ?>
                    <!-- Team Block One -->
                    <div class="team-block_one col-lg-4 col-md-6 col-sm-12">
                        <div class="team-block_one-inner wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <div class="team-block_one-pattern" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/background/pattern-20.png'); ?>)"></div>
                            <div class="team-block_one-image">
                                <?php if (has_post_thumbnail()){ ?>
                                <?php the_post_thumbnail('conat_315x410'); ?>
                                <?php } ?>
                                
                                <?php if($settings['show_social_media']) {
								$icons = get_post_meta( get_the_id(), 'social_profile', true );
								if ( ! empty( $icons ) ) : ?>
                                <div class="team-block_one-social-list">
                                	<?php foreach ( $icons as $h_icon ) :
									$social_icons = json_decode( urldecode( conat_set( $h_icon, 'data' ) ) );
									if ( conat_set( $social_icons, 'enable' ) == '' ) {
										continue;
									}
									$icon_class = explode( '-', conat_set( $social_icons, 'icon' ) ); ?>
									<a href="<?php echo esc_url(conat_set($social_icons, 'url')); ?>" class="fa-brands <?php echo esc_attr( conat_set($social_icons, 'icon') ); ?>" target="_blank"></a>
									<?php endforeach; ?>
                                </div>
                                <?php endif;
								} ?>
                            </div>
                            <div class="team-block_one-content">
                                <h4 class="team-block_one-title">
                                	<?php if($settings['show_link']) { ?>
                                	<a href="<?php echo esc_url(get_permalink(get_the_id())); ?>">
                                    <?php }  ?>
									
                                    <?php the_title(); ?>
                                        
                                    <?php if($settings['show_link']) { ?>
                                    </a>
                                    <?php }  ?>
                                </h4>
                                <div class="team-block_one-designation"><?php echo wp_kses(get_post_meta( get_the_id(), 'designation', true ), true); ?></div>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
                <?php }
				wp_reset_postdata(); ?>
            </div>
        </section>
        <!-- End Team One -->
        
        <?php
    }
}