<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

class Speaker_V1 extends Widget_Base {

    public function get_name() {
        return 'conat_speaker_v1';
    }

    public function get_title() {
        return esc_html__( 'Conat Speaker V1', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'left_pattern_image',
            [
                'label' => __( 'Left Pattern Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'right_pattern_image',
            [
                'label' => __( 'Right Pattern Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->end_controls_section();
		
		//Query
        $this->start_controls_section(
            'query_tab',
            [
                'label' => esc_html__( 'Query', 'conat' ),
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label' => esc_html__( 'Number of post', 'conat' ),
                'type' => Controls_Manager::NUMBER,
                'default' => 8,
                'min'  => 1,
                'max'  => 100,
                'step' => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label' => esc_html__( 'Order By', 'conat' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date' => esc_html__( 'Date', 'conat' ),
                    'title'   => esc_html__( 'Title', 'conat' ),
                    'menu_order' => esc_html__( 'Menu Order', 'conat' ),
                    'rand' => esc_html__( 'Random', 'conat' ),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label' => esc_html__( 'Order', 'conat' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'ASC' => esc_html__( 'Ascending', 'conat' ),
                    'DESC' => esc_html__( 'Descending', 'conat' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'label' => esc_html__('Category', 'conat'),
                'type' => Controls_Manager::SELECT,
                'options' => get_categories_list('speaker_cat')
            ]
        );
        $this->end_controls_section();
		
		//Button
		$this->start_controls_section(
            'button_tab',
            [
                'label' => esc_html__( 'Button', 'conat' ),
            ]
        );
		$this->add_control(
            'style',
            [
                'label' => esc_html__( 'Button / Pagination', 'conat' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'hide',
                'options' => array(
                    'hide' => esc_html__( 'Hide', 'conat' ),
                    'show_button' => esc_html__( 'Button', 'conat' ),
                    'show_pagination' => esc_html__( 'Pagination', 'conat' ),
                ),
            ]
        );
		$this->add_control(
            'btn_style',
            [
                'label' => esc_html__('Style', 'conat'),
                'type' => Controls_Manager::SELECT2,
                'default' => 'one',
                'options' => conat_button_style(),
				'condition' => [
                    'style' => array('show_button')
                ],
            ]
        );
		$this->add_control(
            'btn_name',
            [
                'label' => __( 'Name', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'condition' => [
                    'style' => array('show_button')
                ],
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => __( 'Link', 'conat' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'conat' ),
                'show_external' => true,
                'dynamic' => [
                    'active' => true,
                ],
				'default' => [
					'url' => '#',
				],
				'condition' => [
                    'style' => array('show_button')
                ],
            ]
        );
        $this->end_controls_section();
		
		//Settings
		$this->start_controls_section(
            'setting_tab',
            array(
                'label' => esc_html__( 'Settings', 'conat' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            )
        );
		$this->add_control(
			'show_link',
			array(
				'label' => esc_html__( 'Show Link', 'conat' ),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => array(
					'0'	=> esc_html__( 'No', 'conat' ),
					'1'	=> esc_html__( 'Yes', 'conat' ),
				),
			)
		);
		$this->add_control(
			'show_shadow',
			array(
				'label'			=> esc_html__( 'Show Shadow', 'conat' ),
				'type'			=> Controls_Manager::SELECT,
				'default' => '1',
				'options' => array(
					'0'	=> esc_html__( 'No', 'conat' ),
					'1'	=> esc_html__( 'Yes', 'conat' ),
				),
			)
		);
		$this->add_control(
            'show_border',
            array(
                'label' => esc_html__('Show Border', 'conat'),
                'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => array(
					'0'	=> esc_html__( 'No', 'conat' ),
					'1'	=> esc_html__( 'Yes', 'conat' ),
				),
            )
        );
		$this->add_control(
            'show_social_media',
            array(
                'label' => esc_html__('Show Social Media', 'conat'),
                'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => array(
					'0'	=> esc_html__( 'No', 'conat' ),
					'1'	=> esc_html__( 'Yes', 'conat' ),
				),
            )
        );
		$this->end_controls_section();
    }
	
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

        $paged = get_query_var('paged');
		$paged = conat_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

        $this->add_render_attribute( 'wrapper', 'class', 'themerange-conat' );
        $args = array(
            'post_type' => 'speaker',
            'posts_per_page' => conat_set( $settings, 'query_number' ),
            'orderby' => conat_set( $settings, 'query_orderby' ),
            'order' => conat_set( $settings, 'query_order' ),
            'paged' => $paged
        );

        if( conat_set( $settings, 'query_category' ) ) $args['speaker_cat'] = conat_set( $settings, 'query_category' );
        $query = new \WP_Query( $args ); ?>
        
        <!-- Speakers One -->
        <section class="speakers-one">
            <?php if($settings['right_pattern_image']['id']) { ?><div class="speakers-one_pattern" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['right_pattern_image']['id'])); ?>)"></div><?php } ?>
            <?php if($settings['left_pattern_image']['id']) { ?><div class="speakers-one_pattern-two" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['left_pattern_image']['id'])); ?>)"></div><?php } ?>
            <div class="auto-container">
                <div class="sec-title title-anim centered">
                    <div class="sec-title_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                    <h2 class="sec-title_heading"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                </div>
                
                <?php if ( $query->have_posts() ) { ?>
                <div class="row clearfix">
                	<?php while($query->have_posts()) : $query->the_post(); ?>
                    <!-- Speaker Block One -->
                    <div class="speaker-block_one col-lg-3 col-md-6 col-sm-12">
                        <div class="speaker-block_one-inner wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <?php if (has_post_thumbnail()){ ?>
                            <div class="speaker-block_one-image <?php if($settings['show_border'] == 0) echo 'hide_border'; ?>">
                                <?php the_post_thumbnail('conat_270x280'); ?>
                                
                                <?php if($settings['show_shadow']) { ?>
                                <div class="speaker-block_one-pattern" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/background/pattern-5.png'); ?>)"></div>
                                <?php } ?>
                                
                                <?php if($settings['show_social_media']) {
								$icons = get_post_meta( get_the_id(), 'social_profile', true );
								if ( ! empty( $icons ) ) : ?>
                                <div class="speaker-block_one-social">
                                    <span class="speaker-block_one-share fa-solid fa-share-nodes fa-fw"></span>
                                    <div class="speaker-block_one-social-list">
                                        <?php foreach ( $icons as $h_icon ) :
										$social_icons = json_decode( urldecode( conat_set( $h_icon, 'data' ) ) );
										if ( conat_set( $social_icons, 'enable' ) == '' ) {
											continue;
										}
										$icon_class = explode( '-', conat_set( $social_icons, 'icon' ) ); ?>
										<a href="<?php echo esc_url(conat_set($social_icons, 'url')); ?>" class="fa-brands <?php echo esc_attr( conat_set($social_icons, 'icon') ); ?>" target="_blank"></a>
										<?php endforeach; ?>
                                    </div>
                                </div>
                                <?php endif;
								} ?>
                            </div>
                            <?php } ?>
                            <div class="speaker-block_one-content">
                                <h4 class="speaker-one_title">
                                	<?php if($settings['show_link']) { ?>
                                	<a href="<?php echo esc_url(get_permalink(get_the_id())); ?>">
                                    <?php }  ?>
									
                                    <?php the_title(); ?>
                                        
                                    <?php if($settings['show_link']) { ?>
                                    </a>
                                    <?php }  ?>
                                </h4>
                                <div class="speaker-one_detail"><?php echo wp_kses(get_post_meta( get_the_id(), 'designation', true ), true); ?></div>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                    
                    <?php if($settings['style'] == 'show_button') { ?>
                    <div class="speaker-one_button">
						<?php echo conat_button($settings['btn_style'], $settings['btn_name'], $settings['btn_link']['url']); ?>
                    </div>
                    <?php } elseif($settings['style'] == 'show_pagination') { ?>
                    <!--Styled Pagination-->
                    <?php conat_the_pagination2(array('total' =>$query->max_num_pages, 'next_text' => '<span class="fa fa-angle-double-right"></span>', 'prev_text' => '<span class="fa fa-angle-double-left"></span>')); ?>
                    <!--End Styled Pagination-->
                    <?php } ?>
                </div>
                <?php }
        		wp_reset_postdata(); ?>
            </div>
        </section>
        <!-- End Speakers One -->
        
        <?php
    }
}