<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Speaker_Details extends Widget_Base {

    public function get_name() {
        return 'conat_speaker_details';
    }

    public function get_title() {
        return esc_html__( 'Conat Speaker Details', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
        //Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->end_controls_section();
		
		//Events
		$this->start_controls_section(
            'events_tab',
            [
                'label' => esc_html__( 'Events', 'conat' ),
            ]
        );
		$this->add_control(
            'events',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' =>
				[
					[
						'name' => 'icon',
						'label' => esc_html__('Select Icon', 'conat'),
						'type' => Controls_Manager::SELECT2,
						'label_block' => true,
						'options' => get_fontawesome_icons(),
					],
					[
						'name' => 'room',
						'label' => esc_html__('Room Number', 'conat'),
						'type' => Controls_Manager::TEXT,
					],
					[
						'name' => 'time_start',
						'label' => esc_html__('Time Start', 'conat'),
						'type' => Controls_Manager::SELECT2,
						'default' => '',
						'options' => conat_time_list(),
					],
					[
						'name' => 'time_end',
						'label' => esc_html__('Time End', 'conat'),
						'type' => Controls_Manager::SELECT2,
						'default' => '',
						'options' => conat_time_list(),
					],
					[
						'name' => 'date',
						'label' => esc_html__('Date', 'conat'),
						'type' => Controls_Manager::DATE_TIME,
					],
					[
						'name' => 'day',
						'label' => esc_html__('Day', 'conat'),
						'type' => Controls_Manager::TEXT,
					],
					[
						'name' => 'title',
						'label' => esc_html__('Title', 'conat'),
						'type' => Controls_Manager::TEXT,
						'label_block' => true,
					],
					[
						'name' => 'text',
						'label' => esc_html__('Text', 'conat'),
						'type' => Controls_Manager::TEXTAREA,
					],
					[
						'name' => 'address',
						'label' => esc_html__('Address', 'conat'),
						'type' => Controls_Manager::TEXTAREA,
					],
				],
            ]
        );
        $this->end_controls_section();
		
		//Contact Form
        $this->start_controls_section(
            'contact_tab',
            [
                'label' => esc_html__( 'Contact Form', 'conat' ),
            ]
        );
		$this->add_control(
            'bg_image',
            [
                'label' => __( 'Background Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'title2',
            [
                'label' => __( 'Title', 'conat' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->add_control(
            'cf7_shortocde',
            [
                'label' => esc_html__('Select Form', 'conat'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => get_contact_form_7_list(),
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <!-- Speaker Schedule -->
        <section class="speaker-schedule">
            <div class="auto-container">
                <h4 class="speaker-detail_subtitle"><?php echo wp_kses( $settings['title'], true ); ?></h4>
                <div class="row clearfix">
                	
                    <div class="col-lg-8 col-md-12 col-sm-12">
                        <?php if ($settings['events']){ ?>
                        <?php foreach($settings['events'] as $key => $item) { ?>
                        <!-- Event Block Three -->
                        <div class="event-block_three">
                            <div class="event-block_three-inner">
                                <div class="event-block_three-room">
                                    <div class="event-block_three-icon <?php echo esc_attr($item['icon']); ?>"></div>
                                    <div class="event-block_three-room_number"><?php echo wp_kses( $item['room'], true ); ?> <span><?php echo wp_kses( $item['time_start'], true ); ?> - <?php echo wp_kses( $item['time_end'], true ); ?></span></div>
                                </div>
                                <div class="d-flex flex-wrap">
                                	<?php $date = date("m-d-Y", strtotime($item['date'])); ?>
                                    <div class="event-block_three-date"><?php echo wp_kses($date, true); ?></div>
                                    <div class="event-block_three-day"><?php echo wp_kses( $item['day'], true ); ?></div>
                                </div>
                                <h3 class="event-block_three-heading"><?php echo wp_kses( $item['title'], true ); ?></h3>
                                <div class="event-block_three-text"><?php echo wp_kses( $item['text'], true ); ?></div>
                                <?php if ($item['address']){ ?>
                                <div class="event-block_three-place"><strong><?php esc_html_e('Place:', 'conat'); ?></strong> <?php echo wp_kses( $item['address'], true ); ?></div>
                                <?php } ?>
                            </div>
                        </div>
                        <?php }
						} ?>
                    </div>
                    <div class="col-lg-4 col-md-12 col-sm-12">
                        <div class="speaker-schedule_form" <?php if($settings['bg_image']['id']) { ?>style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>)"<?php } ?>>
                            <div class="speaker-schedule_title-box">
                                <div class="speaker-schedule_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                                <h3 class="speaker-schedule_heading"><?php echo wp_kses( $settings['title2'], true ); ?></h3>
                            </div>
                            
                            <?php if($settings['cf7_shortocde']){ ?>
                            <!-- Team Form -->
                            <div class="faq-form">
                            	<?php echo do_shortcode('[contact-form-7 id="'.esc_attr($settings['cf7_shortocde']).'"]'); ?>
                            </div>
                            <?php } ?>
        
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End Speaker Schedule -->
        
        <?php
    }
}
