<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Slider_V4 extends Widget_Base {

    public function get_name() {
        return 'conat_slider_v4';
    }

    public function get_title() {
        return esc_html__( 'Conat Slider V4', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'owl-slider', TR_URL . 'assets/js/slider.js', [ 'elementor-frontend' ], TR_VERSION, true );
		wp_register_script( 'time-countdown', TR_URL . 'assets/js/time-countdown.js', [ 'elementor-frontend' ], TR_VERSION, true );
		return [ 'owl-slider', 'time-countdown' ];
	}

    protected function _register_controls() {
		//Slider
        $this->start_controls_section(
            'slider_tab',
            [
                'label' => esc_html__( 'Slider', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'bg_image',
			[
				'label' => esc_html__('Background Image ', 'conat'),							
				'type' => Controls_Manager::MEDIA,							
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$repeater->add_control(
			'subtitle',
			[
				'label' => __( 'Sub Title', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'conat' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$repeater->add_control(
			'date',
			[
				'label' => __( 'Date', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'address',
			[
				'label' => __( 'Address', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'btn_style',
			[
				'label' => esc_html__('Button Style', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'default' => 'one',
				'options' => conat_button_style(),
			]
		);
		$repeater->add_control(
			'btn_name',
			[
				'label' => __( 'Button Name', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'btn_link',
			[
				'label' => __( 'Button Link', 'conat' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'conat' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true
				],
				'dynamic'  => [
					'active' => true,
				],
			]
		);
		$this->add_control(
			'slides',
			[
				'label'       => __( 'Slider', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <!-- Banner Section -->
        <section class="banner-section">
            <div class="banner-carousel">
                <div class="main-slider-carousel owl-carousel owl-theme">
                    <?php foreach($settings['slides'] as $key => $item): ?>
                    <!-- Slide Item -->
                    <div class="swiper-slide" <?php if($item['bg_image']['id']) { ?>style="background-image: url(<?php echo esc_url(wp_get_attachment_url($item['bg_image']['id'])); ?>)"><?php } ?>
                        <div class="auto-container">
                            <div class="content-box">
                                <span class="title"><?php echo wp_kses($item['subtitle'], true); ?></span>
                                <h2><?php echo wp_kses($item['title'], true); ?></h2>
                                
                                <?php if($item['date'] or $item['date']) { ?>
                                <ul class="info-list">
                                    <?php if($item['date']) { ?><li><span class="icon flaticon-clock"></span> <?php echo wp_kses($item['date'], true); ?></li><?php } ?>
                                    <?php if($item['address']) { ?><li><span class="icon flaticon-maps-and-flags"></span> <?php echo wp_kses($item['address'], true); ?></li><?php } ?>
                                </ul>
                                <?php } ?>
                                
                                <?php if($item['btn_link']['url'] and $item['btn_name']) { ?>
                                <div class="btn-box">
                                	<?php echo conat_button($item['btn_style'], $item['btn_name'], $item['btn_link']['url']); ?>
                                </div>
                                <?php } ?>
                            </div>  
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <!--End Banner Section -->
        
		<?php
    }
}
