<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Slider_V3 extends Widget_Base {

    public function get_name() {
        return 'conat_slider_v3';
    }

    public function get_title() {
        return esc_html__( 'Conat Slider V3', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'owl-slider', TR_URL . 'assets/js/slider.js', [ 'elementor-frontend' ], TR_VERSION, true );
		wp_register_script( 'time-countdown', TR_URL . 'assets/js/time-countdown.js', [ 'elementor-frontend' ], TR_VERSION, true );
		return [ 'owl-slider', 'time-countdown' ];
	}

    protected function _register_controls() {
        $this->start_controls_section(
            'slider_v3',
            [
                'label' => esc_html__( 'Slider V3', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'bg_image',
			[
				'label' => esc_html__('Background Image ', 'conat'),							
				'type' => Controls_Manager::MEDIA,							
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$repeater->add_control(
			'image_layer',
			[
				'label' => esc_html__('Layer Image ', 'conat'),							
				'type' => Controls_Manager::MEDIA,							
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$repeater->add_control(
			'image',
			[
				'label' => esc_html__('Image ', 'conat'),							
				'type' => Controls_Manager::MEDIA,							
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$repeater->add_control(
			'subtitle',
			[
				'label' => __( 'Sub Title', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'conat' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$repeater->add_control(
			'address',
			[
				'label' => __( 'Address', 'conat' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'date',
			[
				'label' => __( 'Countdown', 'conat' ),
				'type' => Controls_Manager::DATE_TIME,
			]
		);
		$repeater->add_control(
			'btn_style',
			[
				'label' => esc_html__('Button Style', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'default' => 'one',
				'options' => conat_button_style(),
			]
		);
		$repeater->add_control(
			'btn_name',
			[
				'label' => __( 'Button Name', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'btn_link',
			[
				'label' => __( 'Button Link', 'conat' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'conat' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true
				],
				'dynamic'  => [
					'active' => true,
				],
			]
		);
		$this->add_control(
			'slides',
			[
				'label'       => __( 'Slider', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <!-- Slider Three -->
        <section class="slider-three">
            <div class="main-slider-carousel owl-carousel owl-theme">
            	<?php foreach($settings['slides'] as $key => $item): ?>
                <!-- Slide 01 -->
                <div class="slider-three_slide">
                    <?php if($item['image_layer']['id']) { ?><div class="slider-three_pattern-one" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($item['image_layer']['id'])); ?>)"></div><?php } ?>
                    <?php if($item['bg_image']['id']) { ?><div class="slider-three_image-layer" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($item['bg_image']['id'])); ?>)"></div><?php } ?>
                    <div class="auto-container">
                        <div class="row clearfix">
    
                            <!-- Content Column -->
                            <div class="slider-three_content col-lg-7 col-md-12 col-sm-12">
                                <div class="slider-three_content-inner">
                                    <div class="slider-three_title"><?php echo wp_kses($item['subtitle'], true); ?></div>
                                    <h2 class="slider-three_heading"><?php echo wp_kses($item['title'], true); ?></h2>
                                    <div class="slider-three_location"><?php echo wp_kses($item['address'], true); ?></div>
                                    
                                    <?php if ($item['date']){ ?>
                                    <!-- Time Countdown -->
                                    <div class="slider-three_timer">
                                        <div class="time-countdown clearfix" data-countdown="<?php echo esc_attr(date("Y/m/d", strtotime($item['date']))); ?>"></div>
                                    </div>
                                    <?php } ?>
                                    <div class="slider-three_button">
                                        <?php if($item['btn_link']['url'] and $item['btn_name']) {
											echo conat_button($item['btn_style'], $item['btn_name'], $item['btn_link']['url']);
										} ?>
                                    </div>
                                </div>
                            </div>
    
                            <div class="slider-three_image-column col-lg-5 col-md-12 col-sm-12">
                                <?php if($item['image']['id']) { ?>
                                <div class="slider-three_image">
                                    <img src="<?php echo esc_url(wp_get_attachment_url($item['image']['id'])); ?>" alt="<?php esc_html_e('Awesome Image', 'conat'); ?>" />
                                </div>
                                <?php } ?>
                            </div>
    
                        </div>
                    </div>
                </div>
                <!-- End Slide 01 -->
                <?php endforeach; ?>
            </div>
        </section>
        <!-- End Slider Three Section -->
        
		<?php
    }
}
