<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Slider_V2 extends Widget_Base {

    public function get_name() {
        return 'conat_slider_v2';
    }

    public function get_title() {
        return esc_html__( 'Conat Slider V2', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }
	
	public function get_script_depends() {
		wp_register_script( 'owl-slider', TR_URL . 'assets/js/slider.js', [ 'elementor-frontend' ], TR_VERSION, true );
		wp_register_script( 'time-countdown', TR_URL . 'assets/js/time-countdown.js', [ 'elementor-frontend' ], TR_VERSION, true );
		return [ 'owl-slider', 'time-countdown' ];
	}

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'date_tab',
            [
                'label' => esc_html__( 'Coming Date', 'conat' ),
            ]
        );
		$this->add_control(
            'date',
            [
                'label' => __( 'Countdown', 'conat' ),
                'type' => Controls_Manager::DATE_TIME,
            ]
        );
        $this->end_controls_section();
		
		//Slider
		$this->start_controls_section(
            'slider_tab',
            [
                'label' => esc_html__( 'Slider', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'bg_image',
			[
				'label' => esc_html__('Background Image ', 'conat'),							
				'type' => Controls_Manager::MEDIA,							
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$repeater->add_control(
			'cloud_pattern',
			[
				'label' => esc_html__('Cloud Image ', 'conat'),							
				'type' => Controls_Manager::MEDIA,							
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$repeater->add_control(
			'image',
			[
				'label' => esc_html__('Image ', 'conat'),							
				'type' => Controls_Manager::MEDIA,							
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$repeater->add_control(
			'date',
			[
				'label' => __( 'Date', 'conat' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'conat' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$repeater->add_control(
			'address',
			[
				'label' => __( 'Address', 'conat' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'btn_style',
			[
				'label' => esc_html__('Button Style', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'default' => 'one',
				'options' => conat_button_style(),
			]
		);
		$repeater->add_control(
			'btn_name',
			[
				'label' => __( 'Button Name', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'btn_link',
			[
				'label' => __( 'Button Link', 'conat' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'conat' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true
				],
				'dynamic'  => [
					'active' => true,
				],
			]
		);
		$this->add_control(
			'slides',
			[
				'label'       => __( 'Slider', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!-- Slider One -->
        <section class="slider-two">
            <div class="main-slider-carousel owl-carousel owl-theme">
            	<?php foreach($settings['slides'] as $key => $item): ?>
                <!-- Slide 01 -->
                <div class="slider-two_slide">
                	<div class="slider-two_icon-one" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/main-slider/pattern-3.png'); ?>)"></div>
                    <div class="slider-two_icon-two" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/main-slider/pattern-4.png'); ?>)"></div>
                    <div class="slider-two_icon-three" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/main-slider/pattern-5.png'); ?>)"></div>
                    <?php if($item['cloud_pattern']['id']) { ?><div class="slider-two_cloud-layer" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($item['cloud_pattern']['id'])); ?>)"></div><?php } ?>
                    <?php if($item['bg_image']['id']) { ?><div class="slider-two_image-layer" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($item['bg_image']['id'])); ?>)"></div><?php } ?>
                    <div class="auto-container">
                        <div class="row clearfix">
                            <div class="slider-two_image-column col-lg-6 col-md-12 col-sm-12">
                            	<?php if($item['image']['id']) { ?>
                                <div class="slider-two_image">
                                    <img src="<?php echo esc_url(wp_get_attachment_url($item['image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'conat'); ?>" />
                                </div>
                                <?php } ?>
                            </div>
                            <!-- Content Column -->
                            <div class="slider-two_content col-lg-6 col-md-12 col-sm-12">
                                <div class="slider-two_content-inner">
                                    <?php if ($item['date']){ ?><div class="slider-two_date"><?php echo wp_kses($item['date'], true); ?></div><?php } ?>
                                    <h2 class="slider-two_heading"><?php echo wp_kses($item['title'], true); ?></h2>
                                    <?php if ($item['address']){ ?><div class="slider-two_location"><?php echo wp_kses($item['address'], true); ?></div><?php } ?>
                                    <div class="slider-two_button">
                                        <?php if($item['btn_link']['url'] and $item['btn_name']) {
											echo conat_button($item['btn_style'], $item['btn_name'], $item['btn_link']['url']);
										} ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End Slide 01 -->
                <?php endforeach; ?>
            </div>
            
            <?php if ($settings['date']){ ?>
            <!-- Time Countdown -->
            <div class="slider-two_timer">
                <div class="time-countdown clearfix" data-countdown="<?php echo esc_attr(date("Y/m/d", strtotime($settings['date']))); ?>"></div>
            </div>
            <?php } ?>
        </section>
        <!-- End Main Slider Section -->
        
		<?php
    }
}
