<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Slider_V1 extends Widget_Base {

    public function get_name() {
        return 'conat_slider_v1';
    }

    public function get_title() {
        return esc_html__( 'Conat Slider V1', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'owl-slider', TR_URL . 'assets/js/slider.js', [ 'elementor-frontend' ], TR_VERSION, true );
		return [ 'owl-slider' ];
	}

    protected function _register_controls() {
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'pattern_image',
            [
                'label' => __( 'Pattern Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
		//Slider
        $this->start_controls_section(
            'slider_tab',
            [
                'label' => esc_html__( 'Slider', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'bg_image',
			[
				'label' => esc_html__('Background Image ', 'conat'),							
				'type' => Controls_Manager::MEDIA,							
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
        $repeater->add_control(
            'bg_layer_image',
            [
                'label' => __( 'Background Layer Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$repeater->add_control(
			'pattern_image',
			[
				'label' => esc_html__('Pattern Image ', 'conat'),							
				'type' => Controls_Manager::MEDIA,							
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$repeater->add_control(
            'position',
            [
                'label' => esc_html__( 'Address Position', 'conat' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'vertical',
                'options' => array(
                    'vertical' => esc_html__( 'vertical', 'conat' ),
                    'horizontal' => esc_html__( 'horizontal', 'conat' ),
                ),
            ]
        );
		$repeater->add_control(
			'address',
			[
				'label' => __( 'Address', 'conat' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'conat' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$repeater->add_control(
			'day',
			[
				'label' => __( 'Day', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'month',
			[
				'label' => __( 'Month', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'year',
			[
				'label' => __( 'Year', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'btn_style',
			[
				'label' => esc_html__('Button Style', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'default' => 'one',
				'options' => conat_button_style(),
			]
		);
		$repeater->add_control(
			'btn_name',
			[
				'label' => __( 'Button Name', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'btn_link',
			[
				'label' => __( 'Button Link', 'conat' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'conat' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true
				],
				'dynamic'  => [
					'active' => true,
				],
			]
		);
		$this->add_control(
			'slides',
			[
				'label'       => __( 'Slider', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!-- Slider One -->
        <section class="slider-one">
            <?php if($settings['pattern_image']['id']) { ?><div class="slider-one_pattern-two" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_image']['id'])); ?>)"></div><?php } ?>
            <div class="main-slider-carousel owl-carousel owl-theme">
            	<?php foreach($settings['slides'] as $key => $item): ?>
                <!-- Slide 03 -->
                <div class="slider-one_slide">
                    <?php if($item['bg_image']['id']) { ?><div class="slider-one_image-layer" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($item['bg_image']['id'])); ?>)"></div><?php } ?>
                    
                    <?php if($item['bg_layer_image']['id']) { ?><div class="slider-one_color-layer" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($item['bg_layer_image']['id'])); ?>)"></div><?php } ?>
                    
                    <?php if($item['pattern_image']['id']) { ?><div class="slider-one_pattern" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($item['pattern_image']['id'])); ?>)"></div><?php } ?>
                    <div class="auto-container">
                        <!-- Content Column -->
                        <div class="slider-one_content">
                            <div class="slider-one_content-inner">
                                <div class="slider-one_title <?php if($position = 'horizontal') echo 'horizontal'; ?>"><?php echo wp_kses($item['address'], true); ?></div>
                                
								<?php if($item['day'] or $item['month'] or $item['year']) { ?>
                                <div class="slider-one_date"><span><?php echo wp_kses($item['day'], true); ?></span> <?php echo wp_kses($item['month'], true); ?> <br> <?php echo wp_kses($item['year'], true); ?></div>
                                <?php } ?>
                                <h1 class="slider-one_heading"><?php echo wp_kses($item['title'], true); ?></h1>
                                
                                <div class="slider-one_buttons">
                                    <?php if($item['btn_link']['url'] and $item['btn_name']) {
										echo conat_button($item['btn_style'], $item['btn_name'], $item['btn_link']['url']);
									} ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End Slide 03 -->
                <?php endforeach; ?>
            </div>
        </section>
        <!-- End Main Slider Section -->
        
		<?php
    }
}
