<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Register_Now extends Widget_Base {

    public function get_name() {
        return 'conat_register_now';
    }

    public function get_title() {
        return esc_html__( 'Conat Register Now', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
		//Images
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => __( 'Backgruond Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'text',
            [
                'label' => __( 'Text', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->end_controls_section();
		
		//Contact Form
        $this->start_controls_section(
            'contact_tab',
            [
                'label' => esc_html__( 'Contact Form', 'conat' ),
            ]
        );
        $this->add_control(
            'cf7_shortocde',
            [
                'label' => esc_html__('Select Form', 'conat'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => get_contact_form_7_list(),
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <!-- Event Register Section-->
        <section class="event-register-section">
            <!-- Icons -->
            <div class="icons parallax-scene-2">
                <!-- Icon One -->
                <div data-depth="0.20" class="icon-one parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-14.png'); ?>)"></div>
                <!-- Icon Two -->
                <div data-depth="0.50" class="icon-two parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-15.png'); ?>)"></div>
                <!-- Icon Three -->
                <div data-depth="0.10" class="icon-three parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-16.png'); ?>)"></div>
                <!-- Icon Four -->
                <div data-depth="0.30" class="icon-four parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-17.png'); ?>)"></div>
                <!-- Icon Five -->
                <div data-depth="0.10" class="icon-five parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-18.png'); ?>)"></div>
                <!-- Icon Six -->
                <div data-depth="0.20" class="icon-six parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-19.png'); ?>)"></div>
                <!-- Icon Seven -->
                <div data-depth="0.10" class="icon-seven parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-20.png'); ?>)"></div>
                <!-- Icon One -->
                <div data-depth="0.20" class="icon-eight parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-21.png'); ?>)"></div>
                <!-- Icon Two -->
                <div data-depth="0.50" class="icon-nine parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-14.png'); ?>)"></div>
                <!-- Icon Three -->
                <div data-depth="0.10" class="icon-ten parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-18.png'); ?>)"></div>
                <!-- Icon Four -->
                <div data-depth="0.30" class="icon-eleven parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-20.png'); ?>)"></div>
                <!-- Icon Five -->
                <div data-depth="0.10" class="icon-twelve parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-21.png'); ?>)"></div>
                <!-- Icon Six -->
                <div data-depth="0.20" class="icon-thirteen parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-15.png'); ?>)"></div>
                <!-- Icon Seven -->
                <div data-depth="0.10" class="icon-fourteen parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-16.png'); ?>)"></div>
            </div>
            
            <div class="auto-container">
                <!-- Sec Title -->
                <div class="sec-title light centered">
                    <div class="sec-title_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                    <h2 class="sec-title_heading"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                    <div class="sec-title_text"><?php echo wp_kses( $settings['text'], true ); ?></div>
                </div>
                
                <?php if($settings['cf7_shortocde']){ ?>
                <!-- Event Form -->
                <div class="event-form">
                    <?php echo do_shortcode('[contact-form-7 id="'.esc_attr($settings['cf7_shortocde']).'"]'); ?>
                </div>
                <?php } ?>
            </div>
        </section>
        <!-- End Event Register Section-->
            
        <?php
    }
}
