<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Price_Table_V5 extends Widget_Base {

    public function get_name() {
        return 'conat_price_table_v5';
    }

    public function get_title() {
        return esc_html__('Conat Price Table V5', 'conat');
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => __( 'Backgruond Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
        //Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->end_controls_section();
		
		//Price Table
        $this->start_controls_section(
            'slider_tab',
            [
                'label' => esc_html__( 'Price Table', 'conat' ),
            ]
        );
		$this->add_control(
            'column',
            [
                'label' => esc_html__( 'Column', 'conat' ),
                'type' => Controls_Manager::SELECT,
                'default' => '2',
                'options' => array(
                    '2' => esc_html__( '2', 'conat' ),
                    '3' => esc_html__( '3', 'conat' ),
                    '4' => esc_html__( '4', 'conat' ),
                ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
            'price_title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$repeater->add_control(
            'price',
            [
                'label' => __( 'Price', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$repeater->add_control(
            'period',
            [
                'label' => __( 'Period', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$repeater->add_control(
            'text',
            [
                'label' => __( 'Text', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
            ]
        );
		$repeater->add_control(
            'features',
            [
                'label' => __( 'Features', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
		$repeater->add_control(
			'btn_style',
			[
				'label' => esc_html__('Button Style', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'default' => 'one',
				'options' => conat_button_style(),
			]
		);
		$repeater->add_control(
            'btn_name',
            [
                'label' => __( 'Button Name', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            'btn_link',
            [
                'label' => __( 'Button Link', 'conat' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'conat' ),
                'show_external' => true,
                'dynamic'  => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
            ]
        );
		$this->add_control(
			'price_table',
			[
				'label'       => __( 'Price Table', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ price_title }}}',
			]
		);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_html = wp_kses_allowed_html('post'); ?>
        
        <!-- Price One -->
        <section class="price-one">
            <?php if($settings['bg_image']['id']) { ?><div class="price-one_pattern" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>)"></div><?php } ?>
            <div class="auto-container">
                <div class="sec-title title-anim centered">
                    <div class="sec-title_title"><?php echo wp_kses($settings['subtitle'], true); ?></div>
                    <h2 class="sec-title_heading"><?php echo wp_kses($settings['title'], true); ?></h2>
                </div>
                <div class="row clearfix">
                	<?php
					if($settings['column'] == 2)
						$class = 'col-lg-6 col-md-6 col-sm-12';
					else if($settings['column'] == 4)
						$class = 'col-lg-3 col-md-6 col-sm-12';
					else
						$class = 'col-lg-4 col-md-6 col-sm-12';
					?>
                    <?php foreach($settings['price_table'] as $key => $item): ?>
                    <!-- Pricing Block -->
                    <div class="pricing-block wow fadeInLeft <?php echo esc_attr($class); ?>">
                        <div class="inner-box">
                            <div class="upper-box clearfix">
                                <h3 class="title"><?php echo wp_kses($item['price_title'], true); ?></h3>
                                <div class="price"><?php echo wp_kses($item['price'], true); ?><sub><?php echo wp_kses($item['period'], true); ?></sub></div>
                            </div>
    
                            <div class="lower-content">
                                <div class="text"><?php echo wp_kses($item['text'], true); ?></div>
                                
                                <?php $features_list = $item['features'];
								if(!empty($features_list)){
								$features_list = explode("\n", ($features_list)); ?>
								<ul class="feature-list clearfix">
									<?php foreach($features_list as $features): ?>
									<li><?php echo wp_kses($features, $allowed_html); ?></li>
									<?php endforeach; ?>
								</ul>
								<?php } ?>
                                
                                <?php if($item['btn_link']['url'] and $item['btn_name']) { ?>
                                <div class="btn-box">
                                    <?php echo conat_button($item['btn_style'], $item['btn_name'], $item['btn_link']['url']); ?>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <!-- End Price One -->
        
        <?php
    }
}
