<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Price_Table_V4 extends Widget_Base {

    public function get_name() {
        return 'conat_price_table_v4';
    }

    public function get_title() {
        return esc_html__('Conat Price Table V4', 'conat');
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => __( 'Backgruond Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
        //Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'text',
            [
                'label' => __( 'Text', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->end_controls_section();
		
		//Price Table
        $this->start_controls_section(
            'slider_tab',
            [
                'label' => esc_html__( 'Price Table', 'conat' ),
            ]
        );
		$this->add_control(
            'column',
            [
                'label' => esc_html__( 'Column', 'conat' ),
                'type' => Controls_Manager::SELECT,
                'default' => '3',
                'options' => array(
                    '2' => esc_html__( '2', 'conat' ),
                    '3' => esc_html__( '3', 'conat' ),
                    '4' => esc_html__( '4', 'conat' ),
                ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
            'price_title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$repeater->add_control(
            'currency_sign',
            [
                'label' => __( 'Currency Sign', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$repeater->add_control(
            'price',
            [
                'label' => __( 'Price', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$repeater->add_control(
            'period',
            [
                'label' => __( 'Period', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$repeater->add_control(
            'text',
            [
                'label' => __( 'Text', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
		$repeater->add_control(
            'features',
            [
                'label' => __( 'Features', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
		$repeater->add_control(
            'btn_name',
            [
                'label' => __( 'Button Name', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            'btn_link',
            [
                'label' => __( 'Button Link', 'conat' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'conat' ),
                'show_external' => true,
                'dynamic'  => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
            ]
        );
		$this->add_control(
			'price_table',
			[
				'label'       => __( 'Price Table', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ price_title }}}',
			]
		);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_html = wp_kses_allowed_html('post'); ?>
        
        <!-- Event Pricing Section-->
        <section class="event-pricing-section">
            <?php if($settings['bg_image']['id']) { ?><div class="circle-layer" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>)"></div><?php } ?>
            <div class="auto-container">
                <!-- Sec Title -->
                <div class="sec-title centered">
                    <div class="sec-title_title"><?php echo wp_kses($settings['subtitle'], true); ?></div>
                    <h2 class="sec-title_heading"><?php echo wp_kses($settings['title'], true); ?></h2>
                    <div class="sec-title_text"><?php echo wp_kses($settings['text'], true); ?></div>
                </div>
                <div class="row clearfix">
                    <?php
					if($settings['column'] == 2)
						$class = 'col-lg-6 col-md-6 col-sm-12';
					else if($settings['column'] == 4)
						$class = 'col-lg-3 col-md-6 col-sm-12';
					else
						$class = 'col-lg-4 col-md-6 col-sm-12';
					?>
                    <?php foreach($settings['price_table'] as $key => $item): ?>
                    <!-- Event Price Block -->
                    <div class="event-price-block <?php echo esc_attr($class); ?>">
                        <div class="inner-box wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <div class="left-border"></div>
                            <div class="top-border"></div>
                            <div class="right-border"></div>
                            <div class="bottom-border"></div>
                            <div class="title"><?php echo wp_kses($item['price_title'], true); ?></div>
                            <div class="price-box">
                                <div class="box-inner">
                                    <div class="circles-box">
                                        <span class="circle-one"></span>
                                        <span class="circle-two"></span>
                                    </div>
                                    <div class="price"><sup><?php echo wp_kses($item['currency_sign'], true); ?></sup><?php echo wp_kses($item['price'], true); ?><span><?php echo wp_kses($item['period'], true); ?></span></div>
                                </div>
                            </div>
                            <div class="tickets"><?php echo wp_kses($item['text'], true); ?></div>
                            
							<?php $features_list = $item['features'];
							if(!empty($features_list)){
							$features_list = explode("\n", ($features_list)); ?>
							<ul class="price-list">
								<?php foreach($features_list as $features): ?>
								<li><?php echo wp_kses($features, $allowed_html); ?></li>
								<?php endforeach; ?>
							</ul>
							<?php } ?>
							
                            <?php if($item['btn_link']['url'] and $item['btn_name']) {
								echo conat_button('one', $item['btn_name'], $item['btn_link']['url']);
							} ?>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <!-- End Event Pricing Section-->
        
        <?php
    }
}
