<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Price_Table_V2 extends Widget_Base {

    public function get_name() {
        return 'conat_price_table_v2';
    }

    public function get_title() {
        return esc_html__('Conat Price Table V2', 'conat');
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
        //Images
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'left_pattern_image',
            [
                'label' => __( 'Left Pattern Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'right_pattern_image',
            [
                'label' => __( 'Right Pattern Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->end_controls_section();
		
		//Standard Pass
		$this->start_controls_section(
            'standard_tab',
            [
                'label' => esc_html__('Standard Pass', 'conat'),
            ]
        );
		$this->add_control(
            'price_title1',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
		$this->add_control(
            'price1',
            [
                'label' => __( 'Price', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'period1',
            [
                'label' => __( 'Period', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'features1',
            [
				'label' => __( 'Features', 'conat' ),
                'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
                'fields' =>
				[
					[
						'name' => 'style',
						'label' => esc_html__( 'Text Style', 'conat' ),
						'type' => Controls_Manager::SELECT,
						'default' => 'light',
						'options' => array(
							'light' => esc_html__( 'Light', 'conat' ),
							'dark' => esc_html__( 'Dark', 'conat' ),
						),
					],
					[
						'name' => 'title',
						'label' => esc_html__('Title', 'conat'),
						'type' => Controls_Manager::TEXT,
					],
					[
						'name' => 'text',
						'label' => esc_html__('Content', 'conat'),
						'type' => Controls_Manager::TEXTAREA,
					],
				],
            ]
        );
        $this->add_control(
            'btn_name1',
            [
                'label' => __( 'Button Name', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'separator' => 'before',
            ]
        );
        $this->add_control(
            'btn_link1',
            [
                'label' => __( 'Button Link', 'conat' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'conat' ),
                'show_external' => true,
                'dynamic'  => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
            ]
        );
		$this->add_control(
            'bottom_text1',
            [
                'label' => __( 'Bottom Text', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->end_controls_section();
		
		//Flexible Pass
		$this->start_controls_section(
            'flexible_tab',
            [
                'label' => esc_html__('Flexible Pass', 'conat'),
            ]
        );
		$this->add_control(
            'price_title2',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
		$this->add_control(
            'price2',
            [
                'label' => __( 'Price', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'period2',
            [
                'label' => __( 'Period', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'features2',
            [
				'label' => __( 'Features', 'conat' ),
                'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
                'fields' =>
				[
					[
						'name' => 'style',
						'label' => esc_html__( 'Text Style', 'conat' ),
						'type' => Controls_Manager::SELECT,
						'default' => 'light',
						'options' => array(
							'light' => esc_html__( 'Light', 'conat' ),
							'dark' => esc_html__( 'Dark', 'conat' ),
						),
					],
					[
						'name' => 'title',
						'label' => esc_html__('Title', 'conat'),
						'type' => Controls_Manager::TEXT,
					],
					[
						'name' => 'text',
						'label' => esc_html__('Content', 'conat'),
						'type' => Controls_Manager::TEXTAREA,
					],
				],
            ]
        );
        $this->add_control(
            'btn_name2',
            [
                'label' => __( 'Button Name', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'separator' => 'before',
            ]
        );
        $this->add_control(
            'btn_link2',
            [
                'label' => __( 'Button Link', 'conat' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'conat' ),
                'show_external' => true,
                'dynamic'  => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
            ]
        );
		$this->add_control(
            'bottom_text2',
            [
                'label' => __( 'Bottom Text', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->end_controls_section();
		
		//Business Pass
		$this->start_controls_section(
            'business_tab',
            [
                'label' => esc_html__('Business Pass', 'conat'),
            ]
        );
		$this->add_control(
            'price_title3',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
		$this->add_control(
            'price3',
            [
                'label' => __( 'Price', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'period3',
            [
                'label' => __( 'Period', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'features3',
            [
				'label' => __( 'Features', 'conat' ),
                'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
                'fields' =>
				[
					[
						'name' => 'style',
						'label' => esc_html__( 'Text Style', 'conat' ),
						'type' => Controls_Manager::SELECT,
						'default' => 'light',
						'options' => array(
							'light' => esc_html__( 'Light', 'conat' ),
							'dark' => esc_html__( 'Dark', 'conat' ),
						),
					],
					[
						'name' => 'title',
						'label' => esc_html__('Title', 'conat'),
						'type' => Controls_Manager::TEXT,
					],
					[
						'name' => 'text',
						'label' => esc_html__('Content', 'conat'),
						'type' => Controls_Manager::TEXTAREA,
					],
				],
            ]
        );
        $this->add_control(
            'btn_name3',
            [
                'label' => __( 'Button Name', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'separator' => 'before',
            ]
        );
        $this->add_control(
            'btn_link3',
            [
                'label' => __( 'Button Link', 'conat' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'conat' ),
                'show_external' => true,
                'dynamic'  => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
            ]
        );
		$this->add_control(
            'bottom_text3',
            [
                'label' => __( 'Bottom Text', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_html = wp_kses_allowed_html('post'); ?>
        
        <!-- Price Two -->
        <section class="price-two">
            <?php if($settings['left_pattern_image']['id']) { ?><div class="price-two_pattern-one" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['left_pattern_image']['id'])); ?>)"></div><?php } ?>
            <?php if($settings['right_pattern_image']['id']) { ?><div class="price-two_pattern-two" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['right_pattern_image']['id'])); ?>)"></div><?php } ?>
            <div class="auto-container">
                <div class="sec-title title-anim centered">
                    <div class="sec-title_title"><?php echo wp_kses($settings['subtitle'], true); ?></div>
                    <h2 class="sec-title_heading"><?php echo wp_kses($settings['title'], true); ?></h2>
                </div>
                <div class="row clearfix">
                    <!-- Price Block Two -->
                    <div class="price-block_two col-lg-4 col-md-6 col-sm-12">
                        <div class="price-block_two-inner wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <span class="price-block_two-color_layer"></span>
                            <div class="price-block_two-time"><?php echo wp_kses($settings['period1'], true); ?></div>
                            <div class="price-block_two-title"><?php echo wp_kses($settings['price_title1'], true); ?></div>
                            <div class="price-block_two-date"><?php echo wp_kses($settings['price1'], true); ?></div>
                            <div class="price-block_two-content">
                                <?php if ($settings['features1']){ ?>
                                <ul class="price-block_two-options">
                                	<?php foreach($settings['features1'] as $key => $item) { ?>
                                    <li <?php if ($item['style'] == 'light') echo 'class="light"'; ?>><strong><?php echo wp_kses($item['title'], true); ?></strong><?php echo wp_kses($item['text'], true); ?></li>
                                    <?php } ?>
                                </ul>
                                <?php } ?>
                                
                                <?php if($settings['btn_link1']['url'] and $settings['btn_name1']) { ?>
                                <div class="price-block_two-button">
                                	<?php echo conat_button('one', $settings['btn_name1'], $settings['btn_link1']['url']); ?>
                                </div>
                                <?php } ?>
                                <div class="price-block_two-charges"><?php echo wp_kses($settings['bottom_text1'], true); ?></div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Price Block Two -->
                    <div class="price-block_two col-lg-4 col-md-6 col-sm-12">
                        <div class="price-block_two-inner wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <span class="price-block_two-color_layer"></span>
                            <div class="price-block_two-time"><?php echo wp_kses($settings['period2'], true); ?></div>
                            <div class="price-block_two-title"><?php echo wp_kses($settings['price_title2'], true); ?></div>
                            <div class="price-block_two-date"><?php echo wp_kses($settings['price2'], true); ?></div>
                            <div class="price-block_two-content">
                                <?php if ($settings['features2']){ ?>
                                <ul class="price-block_two-options">
                                	<?php foreach($settings['features2'] as $key => $item) { ?>
                                    <li <?php if ($item['style'] == 'light') echo 'class="light"'; ?>><strong><?php echo wp_kses($item['title'], true); ?></strong><?php echo wp_kses($item['text'], true); ?></li>
                                    <?php } ?>
                                </ul>
                                <?php } ?>
                                
                                <?php if($settings['btn_link2']['url'] and $settings['btn_name2']) { ?>
                                <div class="price-block_two-button">
                                	<?php echo conat_button('one', $settings['btn_name2'], $settings['btn_link2']['url']); ?>
                                </div>
                                <?php } ?>
                                <div class="price-block_two-charges"><?php echo wp_kses($settings['bottom_text2'], true); ?></div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Price Block Two -->
                    <div class="price-block_two col-lg-4 col-md-6 col-sm-12">
                        <div class="price-block_two-inner wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <span class="price-block_two-color_layer"></span>
                            <div class="price-block_two-time"><?php echo wp_kses($settings['period3'], true); ?></div>
                            <div class="price-block_two-title"><?php echo wp_kses($settings['price_title3'], true); ?></div>
                            <div class="price-block_two-date"><?php echo wp_kses($settings['price3'], true); ?></div>
                            <div class="price-block_two-content">
                                <?php if ($settings['features3']){ ?>
                                <ul class="price-block_two-options">
                                	<?php foreach($settings['features3'] as $key => $item) { ?>
                                    <li <?php if ($item['style'] == 'light') echo 'class="light"'; ?>><strong><?php echo wp_kses($item['title'], true); ?></strong><?php echo wp_kses($item['text'], true); ?></li>
                                    <?php } ?>
                                </ul>
                                <?php } ?>
                                
                                <?php if($settings['btn_link3']['url'] and $settings['btn_name3']) { ?>
                                <div class="price-block_two-button">
                                	<?php echo conat_button('one', $settings['btn_name3'], $settings['btn_link3']['url']); ?>
                                </div>
                                <?php } ?>
                                <div class="price-block_two-charges"><?php echo wp_kses($settings['bottom_text3'], true); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End Price Two -->
        
        <?php
    }
}
