<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Price_Table_V1 extends Widget_Base {

    public function get_name() {
        return 'conat_price_table_v1';
    }

    public function get_title() {
        return esc_html__('Conat Price Table V1', 'conat');
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => __( 'Background Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->end_controls_section();
		
		//Standard Pass
		$this->start_controls_section(
            'standard_tab',
            [
                'label' => esc_html__('Standard Pass', 'conat'),
            ]
        );
		$this->add_control(
            'price_title1',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
		$this->add_control(
            'price1',
            [
                'label' => __( 'Price', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'period1',
            [
                'label' => __( 'Period', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'features1',
            [
				'label' => __( 'Features', 'conat' ),
                'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
                'fields' =>
				[
					[
						'name' => 'style',
						'label' => esc_html__( 'Text Style', 'conat' ),
						'type' => Controls_Manager::SELECT,
						'default' => 'light',
						'options' => array(
							'light' => esc_html__( 'Light', 'conat' ),
							'dark' => esc_html__( 'Dark', 'conat' ),
						),
					],
					[
						'name' => 'title',
						'label' => esc_html__('Title', 'conat'),
						'type' => Controls_Manager::TEXT,
					],
					[
						'name' => 'text',
						'label' => esc_html__('Content', 'conat'),
						'type' => Controls_Manager::TEXTAREA,
					],
				],
            ]
        );
        $this->add_control(
            'btn_name1',
            [
                'label' => __( 'Button Name', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'separator' => 'before',
            ]
        );
        $this->add_control(
            'btn_link1',
            [
                'label' => __( 'Button Link', 'conat' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'conat' ),
                'show_external' => true,
                'dynamic'  => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
            ]
        );
		$this->add_control(
            'bottom_text1',
            [
                'label' => __( 'Bottom Text', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->end_controls_section();
		
		//Flexible Pass
		$this->start_controls_section(
            'flexible_tab',
            [
                'label' => esc_html__('Flexible Pass', 'conat'),
            ]
        );
		$this->add_control(
            'price_title2',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
		$this->add_control(
            'price2',
            [
                'label' => __( 'Price', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'period2',
            [
                'label' => __( 'Period', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'features2',
            [
				'label' => __( 'Features', 'conat' ),
                'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
                'fields' =>
				[
					[
						'name' => 'style',
						'label' => esc_html__( 'Text Style', 'conat' ),
						'type' => Controls_Manager::SELECT,
						'default' => 'light',
						'options' => array(
							'light' => esc_html__( 'Light', 'conat' ),
							'dark' => esc_html__( 'Dark', 'conat' ),
						),
					],
					[
						'name' => 'title',
						'label' => esc_html__('Title', 'conat'),
						'type' => Controls_Manager::TEXT,
					],
					[
						'name' => 'text',
						'label' => esc_html__('Content', 'conat'),
						'type' => Controls_Manager::TEXTAREA,
					],
				],
            ]
        );
        $this->add_control(
            'btn_name2',
            [
                'label' => __( 'Button Name', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'separator' => 'before',
            ]
        );
        $this->add_control(
            'btn_link2',
            [
                'label' => __( 'Button Link', 'conat' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'conat' ),
                'show_external' => true,
                'dynamic'  => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
            ]
        );
		$this->add_control(
            'bottom_text2',
            [
                'label' => __( 'Bottom Text', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->end_controls_section();
		
		//Business Pass
		$this->start_controls_section(
            'business_tab',
            [
                'label' => esc_html__('Business Pass', 'conat'),
            ]
        );
		$this->add_control(
            'price_title3',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
		$this->add_control(
            'price3',
            [
                'label' => __( 'Price', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'period3',
            [
                'label' => __( 'Period', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'features3',
            [
				'label' => __( 'Features', 'conat' ),
                'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
                'fields' =>
				[
					[
						'name' => 'style',
						'label' => esc_html__( 'Text Style', 'conat' ),
						'type' => Controls_Manager::SELECT,
						'default' => 'light',
						'options' => array(
							'light' => esc_html__( 'Light', 'conat' ),
							'dark' => esc_html__( 'Dark', 'conat' ),
						),
					],
					[
						'name' => 'title',
						'label' => esc_html__('Title', 'conat'),
						'type' => Controls_Manager::TEXT,
					],
					[
						'name' => 'text',
						'label' => esc_html__('Content', 'conat'),
						'type' => Controls_Manager::TEXTAREA,
					],
				],
            ]
        );
        $this->add_control(
            'btn_name3',
            [
                'label' => __( 'Button Name', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'separator' => 'before',
            ]
        );
        $this->add_control(
            'btn_link3',
            [
                'label' => __( 'Button Link', 'conat' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'conat' ),
                'show_external' => true,
                'dynamic'  => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
            ]
        );
		$this->add_control(
            'bottom_text3',
            [
                'label' => __( 'Bottom Text', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_html = wp_kses_allowed_html('post'); ?>
        
        <!-- Price One -->
        <section class="price-one">
            <div class="price-one_pattern" <?php if($settings['bg_image']['id']) { ?>style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>)"<?php } ?>></div>
            <div class="auto-container">
                <div class="sec-title title-anim centered">
                    <div class="sec-title_title"><?php echo wp_kses($settings['subtitle'], true); ?></div>
                    <h2 class="sec-title_heading"><?php echo wp_kses($settings['title'], true); ?></h2>
                </div>
                <div class="row clearfix">
    
                    <!-- Price Block One -->
                    <div class="price-block_one col-lg-4 col-md-6 col-sm-12">
                        <div class="price-block_one-inner wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <div class="price-block_one-pattern" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/background/price-1.png'); ?>)"></div>
                            <div class="price-block_one-pattern-two" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/background/price-1-1.png'); ?>)"></div>
                            <div class="price-block_one-title"><?php echo wp_kses($settings['price_title1'], true); ?></div>
                            <div class="price-block_one-price"><?php echo wp_kses($settings['price1'], true); ?> <span><?php echo wp_kses($settings['period1'], true); ?></span></div>
                            <?php if ($settings['features1']){ ?>
                            <ul class="price-block_one-options">
                            	<?php foreach($settings['features1'] as $key => $item) { ?>
                                <li <?php if ($item['style'] == 'light') echo 'class="light"'; ?>><strong><?php echo wp_kses($item['title'], true); ?></strong><?php echo wp_kses($item['text'], true); ?></li>
                                <?php } ?>
                            </ul>
                            <?php } ?>
                            
                            <?php if($settings['btn_link1']['url'] and $settings['btn_name1']) { ?>
                            <div class="price-block_one-button">
                                <?php echo conat_button('two', $settings['btn_name1'], $settings['btn_link1']['url']); ?>
                            </div>
                            <?php } ?>
                            <div class="price-block_one-charges"><?php echo wp_kses($settings['bottom_text1'], true); ?></div>
                        </div>
                    </div>
                    
                    <!-- Price Block One -->
                    <div class="price-block_one col-lg-4 col-md-6 col-sm-12">
                        <div class="price-block_one-inner wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <div class="price-block_one-pattern" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/background/price-2.png'); ?>)"></div>
                            <div class="price-block_one-pattern-two" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/background/price-2-1.png'); ?>)"></div>
                            <div class="price-block_one-title"><?php echo wp_kses($settings['price_title2'], true); ?></div>
                            <div class="price-block_one-price"><?php echo wp_kses($settings['price2'], true); ?> <span><?php echo wp_kses($settings['period2'], true); ?></span></div>
                            <?php if ($settings['features2']){ ?>
                            <ul class="price-block_one-options">
                            	<?php foreach($settings['features2'] as $key => $item) { ?>
                                <li <?php if ($item['style'] == 'light') echo 'class="light"'; ?>><strong><?php echo wp_kses($item['title'], true); ?></strong><?php echo wp_kses($item['text'], true); ?></li>
                                <?php } ?>
                            </ul>
                            <?php } ?>
                            
                            <?php if($settings['btn_link2']['url'] and $settings['btn_name2']) { ?>
                            <div class="price-block_one-button">
                                <?php echo conat_button('two', $settings['btn_name2'], $settings['btn_link2']['url']); ?>
                            </div>
                            <?php } ?>
                            <div class="price-block_one-charges"><?php echo wp_kses($settings['bottom_text2'], true); ?></div>
                        </div>
                    </div>
                    
                    <!-- Price Block One -->
                    <div class="price-block_one col-lg-4 col-md-6 col-sm-12">
                        <div class="price-block_one-inner wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <div class="price-block_one-pattern" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/background/price-3.png'); ?>)"></div>
                            <div class="price-block_one-pattern-two" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/background/price-3-1.png'); ?>)"></div>
                            <div class="price-block_one-title"><?php echo wp_kses($settings['price_title3'], true); ?></div>
                            <div class="price-block_one-price"><?php echo wp_kses($settings['price3'], true); ?> <span><?php echo wp_kses($settings['period3'], true); ?></span></div>
                            <?php if ($settings['features3']){ ?>
                            <ul class="price-block_one-options">
                            	<?php foreach($settings['features3'] as $key => $item) { ?>
                                <li <?php if ($item['style'] == 'light') echo 'class="light"'; ?>><strong><?php echo wp_kses($item['title'], true); ?></strong><?php echo wp_kses($item['text'], true); ?></li>
                                <?php } ?>
                            </ul>
                            <?php } ?>
                            
                            <?php if($settings['btn_link3']['url'] and $settings['btn_name3']) { ?>
                            <div class="price-block_one-button">
                                <?php echo conat_button('two', $settings['btn_name3'], $settings['btn_link3']['url']); ?>
                            </div>
                            <?php } ?>
                            <div class="price-block_one-charges"><?php echo wp_kses($settings['bottom_text3'], true); ?></div>
                        </div>
                    </div>
    
                </div>
            </div>
        </section>
        <!-- End Price One -->
        
        <?php
    }
}
