<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Partners extends Widget_Base {

    public function get_name() {
        return 'conat_partners';
    }

    public function get_title() {
        return esc_html__( 'Conat Partners', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'partners', TR_URL . 'assets/js/partners.js', [ 'elementor-frontend' ], TR_VERSION, true );
		return [ 'partners' ];
	}

    protected function _register_controls() {
		$this->start_controls_section(
            'settings_tab',
            [
                'label' => esc_html__( 'Settings', 'conat' ),
            ]
        );
		$this->add_control(
            'style',
            [
                'label' => esc_html__( 'Style', 'conat' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'grid',
                'options' => array(
                    'grid' => esc_html__( 'Grid', 'conat' ),
                    'carousel' => esc_html__( 'Carousel', 'conat' ),
                ),
            ]
        );
		$this->add_control(
            'setting',
            [
                'label' => esc_html__( 'Top Extra Space', 'conat' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'no',
                'options' => array(
                    'no' => esc_html__( 'No', 'conat' ),
                    'yes' => esc_html__( 'Yes', 'conat' ),
                ),
				'condition' => [
                    'style' => 'carousel'
                ]
            ]
        );
		$this->end_controls_section();
		
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->end_controls_section();
		
		//Partners Logo
        $this->start_controls_section(
            'partner_tab',
            [
                'label' => esc_html__( 'Partners Logo', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'image',
			[
				'label' => esc_html__('Image', 'conat'),
				'type' => Controls_Manager::MEDIA,
				'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$repeater->add_control(
			'link',
			[
				'label' => esc_html__('URL', 'conat'),
				'type' => Controls_Manager::URL,
				'show_external' => true,
				'dynamic'  => [
					'active' => true,
				],
				'default' => [
					'url' => '#',
				],
			]
		);
		$this->add_control(
			'partners',
			[
				'label'       => __( 'Partners', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <?php if ($settings['style'] == 'carousel'){ ?>
        <!-- Clients Two -->
        <section class="clients-two <?php if ($settings['setting'] == 'yes') echo 'style-two'; ?>">
            <div class="outer-container">
                <div class="sec-title title-anim centered">
                    <div class="sec-title_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                    <h2 class="sec-title_heading"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                </div>
                
                 <?php if ($settings['partners']){ ?>
                <div class="clients_slider owl-carousel owl-theme">
					<?php foreach($settings['partners'] as $key => $item) { ?>
                    <!-- Client Column -->
                    <div class="clients-two_column">
                        <a href="<?php echo esc_url($item['link']['url']); ?>"><img src="<?php echo esc_url(wp_get_attachment_url($item['image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'conat'); ?>"></a>
                    </div>
                    <?php } ?>
                </div>
                <?php } ?>
            </div>
        </section>
        <!-- End Clients Two -->
        
        <?php } else { ?>
        
        <!-- Clients One -->
        <section class="clients-one">
            <div class="auto-container">
                <div class="sec-title title-anim centered">
                    <div class="sec-title_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                    <h2 class="sec-title_heading"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                </div>
                
                <?php if ($settings['partners']){ ?>
                <div class="row clearfix">
                	<?php foreach($settings['partners'] as $key => $item) { ?>
                    <!-- Client Column -->
                    <div class="clients-one_column col-lg-3 col-md-4 col-sm-6">
                    	<?php if ($item['link']['url']) { ?>
                        <a href="<?php echo esc_url($item['link']['url']); ?>">
                        <?php } ?>
                        
                        <img src="<?php echo esc_url(wp_get_attachment_url($item['image']['id'])); ?>" alt="<?php echo esc_attr($item['title']); ?>">
                        
                        <?php if ($item['link']['url']) { ?>
                        </a>
                        <?php } ?>
                    </div>
                    <?php } ?>
                </div>
                <?php } ?>
            </div>
        </section>
        <!-- End Clients One -->
        
        <?php } ?>
        
        <?php
    }
}
