<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

class Our_Features_V2 extends Widget_Base {

    public function get_name() {
        return 'conat_our_features_v1';
    }

    public function get_title() {
        return esc_html__( 'Conat Our Features V2', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'left_pattern_image',
            [
                'label' => __( 'Left Pattern Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'right_pattern_image1',
            [
                'label' => __( 'Right Pattern Image 1', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'right_pattern_image2',
            [
                'label' => __( 'Right Pattern Image 2', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
        //Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->end_controls_section();
		
		//Features
		$this->start_controls_section(
            'features_tab',
            [
                'label' => esc_html__( 'Features', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'icon',
			[
                'label' => __( 'Icon', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
		);
		$repeater->add_control(
			'text',
			[
				'label' => __( 'Text', 'conat' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$repeater->add_control(
			'link',
			[
				'label' => esc_html__('Link', 'conat'),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com/', 'conat' ),
				'show_external' => true,
				'dynamic'  => [
					'active' => true,
				],
				'default' => [
					'url' => '#',
				],
			]
		);
		$this->add_control(
			'features',
			[
				'label'       => __( 'Features', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
		$this->end_controls_section();
    }
	
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <!-- Event Feature Section-->
        <section class="event-feature-section">
            <!-- Icon One -->
            <?php if($settings['left_pattern_image']['id']) { ?><div class="circle-layer" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['left_pattern_image']['id'])); ?>)"></div><?php } ?>
            <?php if($settings['right_pattern_image1']['id']) { ?><div class="circle-layer-two" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['right_pattern_image1']['id'])); ?>)"></div><?php } ?>
            <?php if($settings['right_pattern_image2']['id']) { ?><div class="circle-layer-three" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['right_pattern_image2']['id'])); ?>)"></div><?php } ?>
            <div class="auto-container">
                <!-- Sec Title -->
                <div class="sec-title centered">
                    <div class="sec-title_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                    <h2 class="sec-title_heading"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                </div>
                
                <?php if ($settings['features']){ ?>
                <div class="row clearfix">
                    <?php foreach($settings['features'] as $key => $item) { ?>
                    <!-- Event Feature Block -->
                    <div class="event-feature-block col-lg-4 col-md-6 col-sm-12">
                        <div class="inner-box">
                            <div class="left-border"></div>
                            <div class="top-border"></div>
                            <div class="right-border"></div>
                            <div class="bottom-border"></div>
                            <div class="icon-box">
                                <span class="icon"><img src="<?php echo esc_url(wp_get_attachment_url($item['icon']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'conat'); ?>" /></span>
                            </div>
                            <h4><a href="<?php echo esc_url($item['link']['url']); ?>"><?php echo wp_kses( $item['title'], true ); ?></a></h4>
                            <div class="text"><?php echo wp_kses( $item['text'], true ); ?></div>
                        </div>
                    </div>
                    <?php } ?>
                </div>
                <?php } ?>
            </div>
        </section>
        <!-- End Event Feature Section-->
        
        <?php
    }
}
