<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

class Our_Features extends Widget_Base {

    public function get_name() {
        return 'conat_our_features';
    }

    public function get_title() {
        return esc_html__( 'Conat Our Features V1', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'left_pattern_image',
            [
                'label' => __( 'Left Pattern Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'right_pattern_image',
            [
                'label' => __( 'Right Pattern Image 1', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'right_pattern_image2',
            [
                'label' => __( 'Right Pattern Image 2', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
        //Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->end_controls_section();
		
		//Features
		$this->start_controls_section(
            'features_tab',
            [
                'label' => esc_html__( 'Features', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'icon',
			[
				'label' => esc_html__('Select Icon', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'options' => get_fontawesome_icons(),
			]
		);
		$repeater->add_control(
			'btn_name',
			[
				'label' => esc_html__('Button Name', 'conat'),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'btn_link',
			[
				'label' => esc_html__('Button Link', 'conat'),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com/', 'conat' ),
				'show_external' => true,
				'dynamic'  => [
					'active' => true,
				],
				'default' => [
					'url' => '#',
				],
			]
		);
		$this->add_control(
			'features',
			[
				'label'       => __( 'Features', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <!-- Feature One -->
        <section class="feature-one">
            <?php if($settings['left_pattern_image']['id']) { ?><div class="feature-one_pattern" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['left_pattern_image']['id'])); ?>)"></div><?php } ?>
            <?php if($settings['right_pattern_image']['id']) { ?><div class="feature-one_pattern-two" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['right_pattern_image']['id'])); ?>)"></div><?php } ?>
            <?php if($settings['right_pattern_image2']['id']) { ?><div class="feature-one_pattern-three" data-parallax='{"y" : 80}' style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['right_pattern_image2']['id'])); ?>)"></div><?php } ?>
            <div class="auto-container">
                <div class="sec-title title-anim">
                    <div class="sec-title_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                    <h2 class="sec-title_heading"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                </div>
                
                <?php if ($settings['features']){ ?>
                <div class="row clearfix">
                	<?php foreach($settings['features'] as $key => $item) { ?>
                    <!-- Feature Block One -->
                    <div class="feature-block_one col-lg-3 col-md-6 col-sm-12">
                        <div class="feature-block_one-inner wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <div class="feature-block_one-icon <?php echo esc_attr($item['icon']); ?>"></div>
                            <h4 class="feature-block_one-title"><a href="<?php echo esc_url($item['btn_link']['url']); ?>"><?php echo wp_kses( $item['title'], true ); ?></a></h4>
                            <a href="<?php echo esc_url($item['btn_link']['url']); ?>" class="feature-block_one-more"><?php echo wp_kses( $item['btn_name'], true ); ?></a>
                        </div>
                    </div>
                    <?php } ?>
                </div>
                <?php } ?>
            </div>
        </section>
        <!-- End Feature One -->
        
        <?php
    }
}
