<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class News_V1 extends Widget_Base {

    public function get_name() {
        return 'conat_news_v1';
    }

    public function get_title() {
        return esc_html__( 'Conat News V1', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->end_controls_section();
		
		//Button
		$this->start_controls_section(
            'button_tab',
            [
                'label' => esc_html__( 'Button', 'conat' ),
            ]
        );
		$this->add_control(
            'btn_style',
            [
                'label' => esc_html__('Style', 'conat'),
                'type' => Controls_Manager::SELECT2,
                'default' => 'one',
                'options' => conat_button_style(),
            ]
        );
        $this->add_control(
            'btn_name',
            [
                'label' => __( 'Name', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => __( 'Link', 'conat' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'conat' ),
                'show_external' => true,
                'dynamic'  => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
            ]
        );
        $this->end_controls_section();
		
		//Query
		$this->start_controls_section(
            'query_tab',
            [
                'label' => esc_html__( 'Query', 'conat' ),
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label' => esc_html__( 'Number of post', 'conat' ),
                'type' => Controls_Manager::NUMBER,
                'default' => 3,
                'min'  => 1,
                'max'  => 100,
                'step' => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label' => esc_html__( 'Order By', 'conat' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date' => esc_html__( 'Date', 'conat' ),
                    'title'   => esc_html__( 'Title', 'conat' ),
                    'menu_order' => esc_html__( 'Menu Order', 'conat' ),
                    'rand' => esc_html__( 'Random', 'conat' ),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label' => esc_html__( 'Order', 'conat' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'ASC' => esc_html__( 'Ascending', 'conat' ),
                    'DESC' => esc_html__( 'Descending', 'conat' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'label' => esc_html__('Category', 'conat'),
                'type' => Controls_Manager::SELECT,
                'options' => get_categories_list(),
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

        $paged = get_query_var('paged');
		$paged = conat_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

        $this->add_render_attribute( 'wrapper', 'class', 'themerange-conat' );
        $args = array(
            'post_type' => 'post',
            'posts_per_page' => conat_set( $settings, 'query_number' ),
            'orderby' => conat_set( $settings, 'query_orderby' ),
            'order' => conat_set( $settings, 'query_order' ),
            'paged' => $paged
        );

        if( conat_set( $settings, 'query_category' ) ) $args['category_name'] = conat_set( $settings, 'query_category' );
        $query = new \WP_Query( $args ); ?>
        
        <!-- News One -->
        <section class="news-one">
            <div class="auto-container">
                <div class="sec-title">
                    <div class="d-flex justify-content-between align-items-end flex-wrap">
                        <div class="title-box title-anim">
                            <div class="sec-title_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                            <h2 class="sec-title_heading"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                        </div>
                        <div class="button-box title-anim">
                            <?php if($settings['btn_link']['url'] and $settings['btn_name']) {
								echo conat_button($settings['btn_style'], $settings['btn_name'], $settings['btn_link']['url']);
							} ?>
                        </div>
                    </div>
                </div>
                
                <?php if ( $query->have_posts() ) { ?>
                <div class="row clearfix">
                	<?php while ( $query->have_posts() ) : $query->the_post(); ?>
                    <!-- News Block -->
                    <div class="news-block_one col-lg-4 col-md-6 col-sm-12">
                        <div class="news-block_one-inner">
                        	<?php if (has_post_thumbnail()){ ?>
                            <!-- Post Info -->
                            <div class="news-block_one-image">
                                <a href="<?php echo esc_url(get_permalink(get_the_id())); ?>"><?php the_post_thumbnail('conat_370x500'); ?></a>
                                <?php the_post_thumbnail('conat_370x500'); ?>
                            </div>
                            <?php } ?>
                            <div class="news-block_one-content">
                                <div class="news-block_one-date"><?php echo get_the_date(); ?></div>
                                <ul class="news-block_one-meta">
                                    <li><span class="icon fa-regular fa-calendar fa-fw"></span><?php esc_html_e('by', 'conat'); ?> <?php the_author(); ?></li>
                                    <li><span class="icon fa-solid fa-comments fa-fw"></span><?php comments_number( '(0) Comments', '(1) Comment', '(%) Comments' ); ?></li>
                                </ul>
                                <h5 class="news-block_one-title"><a href="<?php echo esc_url(get_permalink(get_the_id())); ?>"><?php the_title(); ?></a></h5>
                                <a class="news-block_one-more" href="<?php echo esc_url(get_permalink(get_the_id())); ?>"><?php esc_html_e('Read More', 'conat'); ?></a>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
                <?php }
                wp_reset_postdata(); ?>
            </div>
        </section>
        <!-- End News One -->
        
        <?php 
    }
}
