<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Join_The_Event_V3 extends Widget_Base {

    public function get_name() {
        return 'conat_join_the_event_v3';
    }

    public function get_title() {
        return esc_html__( 'Conat Join The Event V3', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
		//Events
		$this->start_controls_section(
            'event_tab',
            [
                'label' => esc_html__( 'Events', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'icon',
			[
				'label' => esc_html__('Select Icon', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'options' => get_fontawesome_icons(),
			]
		);
		$repeater->add_control(
			'text',
			[
				'label' => __( 'Text', 'conat' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$repeater->add_control(
			'btn_style',
			[
				'label' => esc_html__('Button Style', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'default' => 'one',
				'options' => conat_button_style(),
			]
		);
		$repeater->add_control(
			'btn_name',
			[
				'label' => __( 'Button Name', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'btn_link',
			[
				'label' => __( 'Button Link', 'conat' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'conat' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true
				],
				'dynamic'  => [
					'active' => true,
				],
			]
		);
		$this->add_control(
			'events',
			[
				'label'       => __( 'Events', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <?php if ($settings['events']){ ?>
        <!-- Top Features -->
        <section class="top-features">
            <div class="auto-container">
                <div class="row">
                	<?php foreach($settings['events'] as $key => $item) { ?>
                    <!-- Feature Block -->
                    <div class="feature-block col-lg-4 col-md-6 col-sm-12 wow fadeInUp">
                        <div class="inner-box">
                            <div class="icon-box"><span class="icon <?php echo esc_attr($item['icon']); ?>"></span></div>
                            <h4><a href="<?php echo esc_url($item['link']['url']); ?>"><?php echo wp_kses( $item['title'], true ); ?></a></h4>
                            <div class="text"><?php echo wp_kses( $item['text'], true ); ?></div>
                            
                            <?php if($item['btn_link']['url'] and $item['btn_name']) { ?>
                            <div class="btn-box">
                                <?php echo conat_button($item['btn_style'], $item['btn_name'], $item['btn_link']['url']); ?>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </section>
        <!--End Top Features -->
    	<?php } ?>
        
        <?php
    }
}
