<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Join_The_Event_V2 extends Widget_Base {

    public function get_name() {
        return 'conat_join_the_event_v2';
    }

    public function get_title() {
        return esc_html__( 'Conat Join The Event V2', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'pattern_left_image',
            [
                'label' => __( 'Pattern Left Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'pattern_right_image',
            [
                'label' => __( 'Pattern Right Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
        //Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->end_controls_section();
		
		//Events
		$this->start_controls_section(
            'event_tab',
            [
                'label' => esc_html__( 'Events', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'icon',
			[
				'label' => esc_html__('Select Icon', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'options' => get_fontawesome_icons(),
			]
		);
		$repeater->add_control(
			'link',
			[
				'label' => __( 'Link', 'conat' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'conat' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true
				],
				'dynamic'  => [
					'active' => true,
				],
			]
		);
		$repeater->add_control(
			'text',
			[
				'label' => __( 'Text', 'conat' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$this->add_control(
			'events',
			[
				'label'       => __( 'Events', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <!-- Services One -->
        <section class="services-one">
            <?php if($settings['pattern_left_image']['id']) { ?><div class="services-one_pattern-one" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_left_image']['id'])); ?>)"></div><?php } ?>
            <?php if($settings['pattern_right_image']['id']) { ?><div class="services-one_pattern-two" data-parallax='{"y" : 100}' style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_right_image']['id'])); ?>)"></div><?php } ?>
            <div class="auto-container">
                <div class="sec-title centered title-anim">
                    <div class="sec-title_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                    <h2 class="sec-title_heading"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                </div>
                
                <?php if ($settings['events']){ ?>
                <div class="row clearfix">
                	<?php foreach($settings['events'] as $key => $item) { ?>
                    <!-- Service Block One -->
                    <div class="service-block_one col-lg-4 col-md-6 col-sm-12">
                        <div class="service-block_one-inner wow fadeInRight" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <div class="service-block_one-icon <?php echo esc_attr($item['icon']); ?>"></div>
                            <h4 class="service-block_one-heading"><a href="<?php echo esc_url($item['link']['url']); ?>"><?php echo wp_kses( $item['title'], true ); ?></a></h4>
                            <div class="service-block_one-text"><?php echo wp_kses( $item['text'], true ); ?></div>
                            <a href="<?php echo esc_url($item['link']['url']); ?>" class="service-block_one-arrow flaticon-next-2"></a>
                        </div>
                    </div>
                    <?php } ?>
                </div>
                <?php } ?>
            </div>
        </section>
        <!-- End Services One -->
        
        <?php
    }
}
