<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Join_The_Event_V1 extends Widget_Base {

    public function get_name() {
        return 'conat_join_the_event_v1';
    }

    public function get_title() {
        return esc_html__( 'Conat Join The Event V1', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => __( 'Background Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
        //Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->add_control(
            'text',
            [
                'label' => __( 'Text', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->end_controls_section();
		
		//Events
		$this->start_controls_section(
            'events_tab',
            [
                'label' => esc_html__( 'Events', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'icon',
			[
				'label' => esc_html__('Select Icon', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'options' => get_fontawesome_icons(),
			]
		);
		$repeater->add_control(
			'link',
			[
				'label' => __( 'Link', 'conat' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'conat' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true
				],
				'dynamic'  => [
					'active' => true,
				],
			]
		);
		$this->add_control(
			'features',
			[
				'label'       => __( 'Features', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <!-- Event Two -->
        <section class="event-two" <?php if($settings['bg_image']['id']) { ?>style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>)"<?php } ?>>
            <div class="auto-container">
                <div class="sec-title light centered title-anim">
                    <div class="sec-title_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                    <h2 class="sec-title_heading"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                    <div class="sec-title_text"><?php echo wp_kses( $settings['text'], true ); ?></div>
                </div>
                
                <?php if ($settings['features']){ ?>
                <div class="clearfix">
                	<?php foreach($settings['features'] as $key => $item) { ?>
                    <!-- Event Block Two -->
                    <div class="event-block_two">
                        <div class="event-block_two-inner">
                            <div class="event-block_two-icon <?php echo esc_attr($item['icon']); ?>"></div>
                            <h5 class="event-block_two-title"><a href="<?php echo esc_url($item['link']['url']); ?>"><?php echo wp_kses( $item['title'], true ); ?></a></h5>
                        </div>
                    </div>
                    <?php } ?>
                </div>
                <?php } ?>
            </div>
        </section>
        <!-- End Event Two -->
        
        <?php
    }
}
